/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public record OpenMaidGuiPackage(int entityId, int tabId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenMaidGuiPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("open_maid_gui"));
    public static final StreamCodec<ByteBuf, OpenMaidGuiPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, OpenMaidGuiPackage::entityId, (StreamCodec)ByteBufCodecs.VAR_INT, OpenMaidGuiPackage::tabId, OpenMaidGuiPackage::new);

    public OpenMaidGuiPackage(int entityId) {
        this(entityId, 0);
    }

    public static void handle(OpenMaidGuiPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> OpenMaidGuiPackage.handle(message, (ServerPlayer)context.player()));
        }
    }

    private static void handle(OpenMaidGuiPackage message, @Nullable ServerPlayer player) {
        EntityMaid maid;
        if (player == null) {
            return;
        }
        Entity entity = player.level.getEntity(message.entityId);
        if (entity instanceof EntityMaid && OpenMaidGuiPackage.stillValid((Player)player, maid = (EntityMaid)entity)) {
            maid.openMaidGui((Player)player, message.tabId);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static boolean stillValid(Player playerIn, EntityMaid maid) {
        return maid.isOwnedBy((LivingEntity)playerIn) && !maid.isSleeping() && maid.isAlive() && maid.distanceTo((Entity)playerIn) < 5.0f;
    }
}

