/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SpawnParticlePackage(int entityId, Type particleType, int delayTicks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpawnParticlePackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("spawn_particle"));
    public static final StreamCodec<ByteBuf, SpawnParticlePackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SpawnParticlePackage::entityId, Type.STREAM_CODEC, SpawnParticlePackage::particleType, (StreamCodec)ByteBufCodecs.VAR_INT, SpawnParticlePackage::delayTicks, SpawnParticlePackage::new);

    public SpawnParticlePackage(int entityId, Type particleType) {
        this(entityId, particleType, 0);
    }

    public static void handle(SpawnParticlePackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            if (message.delayTicks <= 0) {
                context.enqueueWork(() -> SpawnParticlePackage.handleSpawnParticle(message));
            } else {
                context.enqueueWork(() -> CompletableFuture.runAsync(() -> SpawnParticlePackage.handleSpawnParticleDelay(message, message.delayTicks), Util.backgroundExecutor()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSpawnParticleDelay(SpawnParticlePackage message, int delayTicks) {
        try {
            Thread.sleep((long)delayTicks * 50L);
            Minecraft.getInstance().submitAsync(() -> SpawnParticlePackage.handleSpawnParticle(message));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSpawnParticle(SpawnParticlePackage message) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Entity e = mc.level.getEntity(message.entityId);
        if (e instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)e;
            if (e.isAlive()) {
                switch (message.particleType.ordinal()) {
                    case 0: {
                        maid.spawnExplosionParticle();
                        return;
                    }
                    case 1: {
                        maid.spawnBubbleParticle();
                        return;
                    }
                    case 2: {
                        maid.spawnHeartParticle();
                        return;
                    }
                    case 3: {
                        maid.spawnRankUpParticle();
                        return;
                    }
                    case 4: {
                        maid.spawnRestoreHealthParticle(maid.getRandom().nextInt(3) + 7);
                        return;
                    }
                }
            }
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Type {
        EXPLOSION,
        BUBBLE,
        HEART,
        RANK_UP,
        HEAL;

        public static final IntFunction<Type> BY_ID;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

