/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public final class TeleportHelper {
    public static boolean teleport(EntityMaid maid) {
        if (!maid.level.isClientSide() && maid.isAlive()) {
            double x = maid.getX() + (maid.getRandom().nextDouble() - 0.5) * 16.0;
            double y = maid.getY() + (double)maid.getRandom().nextInt(16) - 8.0;
            double z = maid.getZ() + (maid.getRandom().nextDouble() - 0.5) * 16.0;
            return TeleportHelper.teleport(maid, x, y, z);
        }
        return false;
    }

    public static boolean teleportToRestrictCenter(EntityMaid maid) {
        BlockPos blockPos = maid.getRestrictCenter();
        if (!maid.level.isClientSide() && maid.isAlive()) {
            int x = blockPos.getX() + TeleportHelper.randomIntInclusive(maid.getRandom(), -3, 3);
            int y = blockPos.getY() + TeleportHelper.randomIntInclusive(maid.getRandom(), 0, 3);
            int z = blockPos.getZ() + TeleportHelper.randomIntInclusive(maid.getRandom(), -3, 3);
            return TeleportHelper.teleport(maid, x, y, z);
        }
        return false;
    }

    private static boolean teleport(EntityMaid maid, double x, double y, double z) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockPos.getY() > maid.level.getMinBuildHeight() && !maid.level.getBlockState((BlockPos)blockPos).blocksMotion()) {
            blockPos.move(Direction.DOWN);
        }
        BlockState blockState = maid.level.getBlockState((BlockPos)blockPos);
        boolean isMotion = blockState.blocksMotion();
        boolean isWater = blockState.getFluidState().is(FluidTags.WATER);
        if (isMotion && !isWater) {
            boolean teleportIsSuccess = maid.randomTeleport(x, y, z, true);
            if (teleportIsSuccess && !maid.isSilent()) {
                maid.level.playSound(null, maid.xo, maid.yo, maid.zo, SoundEvents.ENDERMAN_TELEPORT, maid.getSoundSource(), 1.0f, 1.0f);
                maid.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
            return teleportIsSuccess;
        }
        return false;
    }

    private static int randomIntInclusive(RandomSource random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }
}

