/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util.http;

import com.github.tartaricacid.touhoulittlemaid.util.http.MultiPartRecord;
import com.github.tartaricacid.touhoulittlemaid.util.http.MultipartBody;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.util.List;

public class MultipartBodyBuilder {
    private static final String CRLF = "\r\n";
    private static final String CONTENT_TYPE = "Content-Type: %s\r\n\r\n";
    private final List<MultiPartRecord> parts = Lists.newArrayList();

    public MultipartBodyBuilder addText(String fieldName, String fieldValue) {
        return this.addPart(fieldName, fieldValue, MediaType.PLAIN_TEXT_UTF_8.toString());
    }

    public MultipartBodyBuilder addPart(String fieldName, String fieldValue, String contentType) {
        MultiPartRecord part = new MultiPartRecord();
        part.setFieldName(fieldName);
        part.setContent(fieldValue);
        part.setContentType(contentType);
        this.parts.add(part);
        return this;
    }

    public MultipartBodyBuilder addPart(String fieldName, Object fieldValue, String contentType, String fileName) {
        MultiPartRecord part = new MultiPartRecord();
        part.setFieldName(fieldName);
        part.setContent(fieldValue);
        part.setContentType(contentType);
        part.setFileName(fileName);
        this.parts.add(part);
        return this;
    }

    public MultipartBody build() throws IOException {
        String boundary = new BigInteger(256, new SecureRandom()).toString();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (MultiPartRecord record : this.parts) {
            out.write(this.getHead(record, boundary));
            Object content = record.getContent();
            if (content instanceof String) {
                String text = (String)content;
                out.write(CRLF.getBytes(StandardCharsets.UTF_8));
                out.write(text.getBytes(StandardCharsets.UTF_8));
            } else if (content instanceof byte[]) {
                byte[] bytes = (byte[])content;
                out.write(CONTENT_TYPE.formatted(record.getContentType()).getBytes(StandardCharsets.UTF_8));
                out.write(bytes);
            } else if (content instanceof File) {
                File file = (File)content;
                out.write(CONTENT_TYPE.formatted(record.getContentType()).getBytes(StandardCharsets.UTF_8));
                Files.copy(file.toPath(), out);
            } else {
                throw new IllegalArgumentException("Unsupported content type: " + String.valueOf(content.getClass()));
            }
            out.write(CRLF.getBytes(StandardCharsets.UTF_8));
        }
        out.write(this.getEnd(boundary));
        return new MultipartBody(out.toByteArray(), boundary);
    }

    private byte[] getHead(MultiPartRecord record, String boundary) {
        byte[] head = record.getFileName() == null ? "--%s\r\nContent-Disposition: form-data; name=\"%s\"\r\n".formatted(boundary, record.getFieldName()).getBytes(StandardCharsets.UTF_8) : "--%s\r\nContent-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n".formatted(boundary, record.getFieldName(), record.getFileName()).getBytes(StandardCharsets.UTF_8);
        return head;
    }

    private byte[] getEnd(String boundary) {
        return "--%s--\r\n".formatted(boundary).getBytes(StandardCharsets.UTF_8);
    }
}

