/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.world.data;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class MaidWorldData
extends SavedData {
    private static final String IDENTIFIER = "touhou_little_maid_world_data";
    private static final String MAID_INFOS_TAG = "MaidInfos";
    private static final String MAID_TOMBSTONES_TAG = "MaidTombstones";
    private final Map<UUID, List<MaidInfo>> infos = Maps.newHashMap();
    private final Map<UUID, List<MaidInfo>> tombstones = Maps.newHashMap();

    public static SavedData.Factory<MaidWorldData> factory() {
        return new SavedData.Factory(MaidWorldData::new, MaidWorldData::load, DataFixTypes.ENTITY_CHUNK);
    }

    @Nullable
    public static MaidWorldData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel overWorld = level.getServer().getLevel(Level.OVERWORLD);
            if (overWorld == null) {
                return null;
            }
            DimensionDataStorage storage = overWorld.getDataStorage();
            MaidWorldData data = (MaidWorldData)storage.computeIfAbsent(MaidWorldData.factory(), IDENTIFIER);
            data.setDirty();
            return data;
        }
        return null;
    }

    public static MaidWorldData load(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        MutableComponent name;
        long timestamp;
        UUID ownerId;
        BlockPos chunkPos;
        String dimension;
        CompoundTag infoTag;
        int i;
        ListTag listTag;
        MaidWorldData data = new MaidWorldData();
        if (tag.contains(MAID_INFOS_TAG, 10)) {
            CompoundTag infosTag = tag.getCompound(MAID_INFOS_TAG);
            for (String key : infosTag.getAllKeys()) {
                listTag = infosTag.getList(key, 10);
                for (i = 0; i < listTag.size(); ++i) {
                    infoTag = listTag.getCompound(i);
                    dimension = infoTag.getString("Dimension");
                    chunkPos = NbtUtils.readBlockPos((CompoundTag)infoTag, (String)"ChunkPos").orElse(null);
                    if (chunkPos == null) continue;
                    ownerId = infoTag.getUUID("OwnerId");
                    UUID maidId = infoTag.getUUID("MaidId");
                    timestamp = infoTag.getLong("Timestamp");
                    name = Component.Serializer.fromJson((String)infoTag.getString("Name"), (HolderLookup.Provider)provider);
                    List maidInfos = data.infos.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
                    maidInfos.add(new MaidInfo(dimension, chunkPos, ownerId, maidId, timestamp, (Component)name));
                }
            }
        }
        if (tag.contains(MAID_TOMBSTONES_TAG, 10)) {
            CompoundTag tombstonesTag = tag.getCompound(MAID_TOMBSTONES_TAG);
            for (String key : tombstonesTag.getAllKeys()) {
                listTag = tombstonesTag.getList(key, 10);
                for (i = 0; i < listTag.size(); ++i) {
                    infoTag = listTag.getCompound(i);
                    dimension = infoTag.getString("Dimension");
                    chunkPos = NbtUtils.readBlockPos((CompoundTag)infoTag, (String)"ChunkPos").orElse(null);
                    if (chunkPos == null) continue;
                    ownerId = infoTag.getUUID("OwnerId");
                    UUID tombstoneId = infoTag.getUUID("TombstoneId");
                    timestamp = infoTag.getLong("Timestamp");
                    name = Component.Serializer.fromJson((String)infoTag.getString("Name"), (HolderLookup.Provider)provider);
                    List tombstoneInfos = data.tombstones.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
                    tombstoneInfos.add(new MaidInfo(dimension, chunkPos, ownerId, tombstoneId, timestamp, (Component)name));
                }
            }
        }
        return data;
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag infosTag = new CompoundTag();
        this.infos.forEach((id, data) -> {
            ListTag listTag = new ListTag();
            data.forEach(info -> {
                if (info.getChunkPos() == null) {
                    return;
                }
                CompoundTag infoTag = new CompoundTag();
                infoTag.putString("Dimension", info.getDimension());
                infoTag.put("ChunkPos", NbtUtils.writeBlockPos((BlockPos)info.getChunkPos()));
                infoTag.putUUID("OwnerId", info.getOwnerId());
                infoTag.putUUID("MaidId", info.getEntityId());
                infoTag.putLong("Timestamp", info.getTimestamp());
                infoTag.putString("Name", Component.Serializer.toJson((Component)info.getName(), (HolderLookup.Provider)provider));
                listTag.add((Object)infoTag);
            });
            infosTag.put(id.toString(), (Tag)listTag);
        });
        CompoundTag tombstonesTag = new CompoundTag();
        this.tombstones.forEach((id, data) -> {
            ListTag listTag = new ListTag();
            data.forEach(info -> {
                if (info.getChunkPos() == null) {
                    return;
                }
                CompoundTag infoTag = new CompoundTag();
                infoTag.putString("Dimension", info.getDimension());
                infoTag.put("ChunkPos", NbtUtils.writeBlockPos((BlockPos)info.getChunkPos()));
                infoTag.putUUID("OwnerId", info.getOwnerId());
                infoTag.putUUID("TombstoneId", info.getEntityId());
                infoTag.putLong("Timestamp", info.getTimestamp());
                infoTag.putString("Name", Component.Serializer.toJson((Component)info.getName(), (HolderLookup.Provider)provider));
                listTag.add((Object)infoTag);
            });
            tombstonesTag.put(id.toString(), (Tag)listTag);
        });
        tag.put(MAID_INFOS_TAG, (Tag)infosTag);
        tag.put(MAID_TOMBSTONES_TAG, (Tag)tombstonesTag);
        return tag;
    }

    public void addInfo(MaidInfo info) {
        UUID ownerId = info.getOwnerId();
        List maidInfos = this.infos.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
        maidInfos.add(info);
        this.setDirty();
    }

    public void addInfo(EntityMaid maid) {
        String dimension = maid.level.dimension().location().toString();
        BlockPos chunkPos = maid.blockPosition();
        UUID ownerId = maid.getOwnerUUID();
        UUID maidId = maid.getUUID();
        long timestamp = System.currentTimeMillis();
        Component name = maid.getDisplayName();
        this.addInfo(new MaidInfo(dimension, chunkPos, ownerId, maidId, timestamp, name));
    }

    public void removeInfo(EntityMaid maid) {
        UUID ownerId = maid.getOwnerUUID();
        if (this.infos.containsKey(ownerId)) {
            UUID maidId = maid.getUUID();
            this.infos.get(ownerId).removeIf(info -> info.getEntityId().equals(maidId));
            this.setDirty();
        }
    }

    @Nullable
    public List<MaidInfo> getInfos(UUID owner) {
        return this.infos.get(owner);
    }

    @Nullable
    public List<MaidInfo> getPlayerMaidInfos(Player player) {
        return this.infos.get(player.getUUID());
    }

    public void addTombstones(MaidInfo info) {
        UUID ownerId = info.getOwnerId();
        List tombstoneInfos = this.tombstones.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
        tombstoneInfos.add(info);
        this.setDirty();
    }

    public void addTombstones(EntityMaid maid, EntityTombstone tombstone) {
        String dimension = maid.level.dimension().location().toString();
        BlockPos chunkPos = tombstone.blockPosition();
        UUID ownerId = maid.getOwnerUUID();
        UUID tombstoneId = tombstone.getUUID();
        long timestamp = System.currentTimeMillis();
        Component name = maid.getDisplayName();
        this.addTombstones(new MaidInfo(dimension, chunkPos, ownerId, tombstoneId, timestamp, name));
    }

    public void removeTombstones(EntityTombstone tombstone) {
        UUID ownerId = tombstone.getOwnerId();
        if (this.tombstones.containsKey(ownerId)) {
            UUID tombstoneId = tombstone.getUUID();
            this.tombstones.get(ownerId).removeIf(info -> info.getEntityId().equals(tombstoneId));
            this.setDirty();
        }
    }

    @Nullable
    public List<MaidInfo> getTombstones(UUID owner) {
        return this.tombstones.get(owner);
    }

    @Nullable
    public List<MaidInfo> getPlayerMaidTombstones(Player player) {
        return this.tombstones.get(player.getUUID());
    }
}

