package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.event.common;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import dev.latvian.mods.kubejs.entity.LivingEntityEventJS;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;

public class MaidAttackEventJS extends LivingEntityEventJS {
    private final EntityMaid maid;
    private final DamageSource source;
    private final float amount;

    public MaidAttackEventJS(MaidAttackEvent event) {
        this.maid = event.getMaid();
        this.source = event.getSource();
        this.amount = event.getAmount();
    }

    public EntityMaid getMaid() {
        return maid;
    }

    public DamageSource getSource() {
        return source;
    }

    public float getAmount() {
        return amount;
    }

    @Override
    public LivingEntity getEntity() {
        return maid;
    }
}
