/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.event.client;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.eventbus.api.Event;

public abstract class MaidContainerGuiEvent
extends Event {
    protected final AbstractMaidContainerGui<?> gui;
    protected final int leftPos;
    protected final int topPos;
    protected final Map<String, AbstractWidget> buttons;

    public MaidContainerGuiEvent(AbstractMaidContainerGui<?> gui, int leftPos, int topPos, Map<String, AbstractWidget> buttons) {
        this.gui = gui;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.buttons = buttons;
    }

    public AbstractMaidContainerGui<?> getGui() {
        return this.gui;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public AbstractWidget getButton(String name) {
        return this.buttons.get(name);
    }

    public boolean hasButton(String name) {
        return this.buttons.containsKey(name);
    }

    public static class Tooltip
    extends MaidContainerGuiEvent {
        private final GuiGraphics graphics;
        private final int mouseX;
        private final int mouseY;
        private final float partialTicks;

        public Tooltip(AbstractMaidContainerGui<?> gui, int leftPos, int topPos, Map<String, AbstractWidget> buttons, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super(gui, leftPos, topPos, buttons);
            this.graphics = graphics;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.partialTicks = partialTicks;
        }

        public GuiGraphics getGraphics() {
            return this.graphics;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getPartialTicks() {
            return this.partialTicks;
        }
    }

    public static class Render
    extends MaidContainerGuiEvent {
        private final GuiGraphics graphics;
        private final int mouseX;
        private final int mouseY;
        private final float partialTicks;

        public Render(AbstractMaidContainerGui<?> gui, int leftPos, int topPos, Map<String, AbstractWidget> buttons, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super(gui, leftPos, topPos, buttons);
            this.graphics = graphics;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.partialTicks = partialTicks;
        }

        public GuiGraphics getGraphics() {
            return this.graphics;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getPartialTicks() {
            return this.partialTicks;
        }
    }

    public static class Init
    extends MaidContainerGuiEvent {
        public Init(AbstractMaidContainerGui<?> gui, int leftPos, int topPos, Map<String, AbstractWidget> buttons) {
            super(gui, leftPos, topPos, buttons);
        }

        public void addButton(String name, AbstractWidget button) {
            if (!this.buttons.containsKey(name)) {
                this.buttons.put(name, button);
            }
        }

        public void removeButton(String name) {
            this.buttons.remove(name);
        }
    }
}

