/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.CropBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IPlantable;

public interface ISpecialCropHandler {
    default public boolean isSeed(ItemStack stack) {
        return true;
    }

    default public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        return false;
    }

    default public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, boolean isDestroyMode) {
        if (isDestroyMode) {
            maid.destroyBlock(cropPos);
        } else {
            Block block = cropState.m_60734_();
            if (block instanceof CropBlockAccessor) {
                CropBlockAccessor crop = (CropBlockAccessor)block;
                BlockEntity blockEntity = cropState.m_155947_() ? maid.f_19853_.m_7702_(cropPos) : null;
                maid.dropResourcesToMaidInv(cropState, maid.f_19853_, cropPos, blockEntity, maid, maid.m_21205_());
                maid.f_19853_.m_46796_(2001, cropPos, Block.m_49956_((BlockState)cropState));
                if (cropState.m_61138_((Property)crop.tlmAgeProperty())) {
                    try {
                        cropState = (BlockState)cropState.m_263224_((Property)crop.tlmAgeProperty(), (Comparable)Integer.valueOf(0));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                maid.f_19853_.m_7731_(cropPos, cropState, 3);
                maid.f_19853_.m_142346_((Entity)maid, GameEvent.f_157792_, cropPos);
            }
        }
    }

    default public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        ItemNameBlockItem blockNamedItem;
        Block block;
        BlockState aboveState = maid.f_19853_.m_8055_(basePos.m_7494_());
        if (!aboveState.m_247087_() || aboveState.m_278721_()) {
            return false;
        }
        Item item = seed.m_41720_();
        if (item instanceof ItemNameBlockItem && (block = (blockNamedItem = (ItemNameBlockItem)item).m_40614_()) instanceof IPlantable) {
            IPlantable plant = (IPlantable)block;
            return baseState.canSustainPlant((BlockGetter)maid.f_19853_, basePos, Direction.UP, plant);
        }
        return false;
    }

    default public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        ItemNameBlockItem blockNamedItem;
        Block block;
        Item item = seed.m_41720_();
        if (item instanceof ItemNameBlockItem && (block = (blockNamedItem = (ItemNameBlockItem)item).m_40614_()) instanceof IPlantable) {
            maid.placeItemBlock(basePos.m_7494_(), seed);
        }
        return seed;
    }
}

