/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskButton
extends Button
implements ITooltipButton {
    private final IMaidTask task;
    private final boolean enable;
    private final ResourceLocation resourceLocation;
    private final int xTexStart;
    private final int yTexStart;
    private final int yDiffTex;
    private final int textureWidth;
    private final int textureHeight;
    private final List<Component> tooltips;

    public TaskButton(IMaidTask task, boolean enable, int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, Button.OnPress onPressIn) {
        this(task, enable, xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, 256, 256, onPressIn);
    }

    public TaskButton(IMaidTask task, boolean enable, int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, int textureWidth, int textureHeight, Button.OnPress onPressIn) {
        this(task, enable, xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, textureWidth, textureHeight, onPressIn, (Component)Component.m_237119_());
    }

    public TaskButton(IMaidTask task, boolean enable, int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation resourceLocation, int textureWidth, int textureHeight, Button.OnPress onPress, Component title) {
        this(task, enable, x, y, width, height, xTexStart, yTexStart, yDiffText, resourceLocation, textureWidth, textureHeight, onPress, Collections.emptyList(), title);
    }

    public TaskButton(IMaidTask task, boolean enable, int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation resourceLocation, int textureWidth, int textureHeight, Button.OnPress onPress, List<Component> tooltips, Component title) {
        super(x, y, width, height, title, onPress, Supplier::get);
        this.task = task;
        this.enable = enable;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.yDiffTex = yDiffText;
        this.resourceLocation = resourceLocation;
        this.tooltips = tooltips;
    }

    public IMaidTask getTask() {
        return this.task;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.enable) {
            return false;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        int i = this.yTexStart;
        if (this.m_198029_()) {
            i += this.yDiffTex;
        }
        RenderSystem.enableDepthTest();
        graphics.m_280163_(this.resourceLocation, this.m_252754_(), this.m_252907_(), (float)this.xTexStart, (float)i, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
        if (!this.enable) {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, Integer.MIN_VALUE);
            graphics.m_280163_(this.resourceLocation, this.m_252754_() + 72, this.m_252907_(), 93.0f, 68.0f, 7, 19, this.textureWidth, this.textureHeight);
        }
        graphics.m_280480_(this.task.getIcon(), this.m_252754_() + 2, this.m_252907_() + 2);
        graphics.m_280614_(minecraft.f_91062_, (Component)this.task.getName(), this.m_252754_() + 23, this.m_252907_() + 6, 0x333333, false);
    }

    @Override
    public boolean isTooltipHovered() {
        return this.m_274382_();
    }

    @Override
    public void renderTooltip(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        if (!this.tooltips.isEmpty()) {
            graphics.m_280666_(mc.f_91062_, this.tooltips, mouseX, mouseY);
        }
    }
}

