/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class FilePackTexture
extends SizeTexture {
    private final ResourceLocation texturePath;
    private final Path rootPath;
    private int width = 16;
    private int height = 16;

    public FilePackTexture(Path rootPath, ResourceLocation texturePath) {
        this.rootPath = rootPath;
        this.texturePath = texturePath;
    }

    @Override
    public boolean isExist() {
        File textureFile = this.rootPath.resolve("assets").resolve(this.texturePath.m_135827_()).resolve(this.texturePath.m_135815_()).toFile();
        return textureFile.isFile();
    }

    public void m_6704_(ResourceManager manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        File textureFile = this.rootPath.resolve("assets").resolve(this.texturePath.m_135827_()).resolve(this.texturePath.m_135815_()).toFile();
        if (textureFile.isFile()) {
            try (InputStream stream = Files.newInputStream(textureFile.toPath(), new OpenOption[0]);){
                NativeImage imageIn = NativeImage.m_85058_((InputStream)stream);
                this.width = imageIn.m_84982_();
                this.height = imageIn.m_85084_();
                TextureUtil.prepareImage((int)this.m_117963_(), (int)0, (int)this.width, (int)this.height);
                imageIn.m_85013_(0, 0, 0, 0, 0, this.width, this.height, false, false, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

