/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class MaidCommand {
    private static final String MAID_NAME = "maid";
    private static final String TARGETS_NAME = "targets";
    private static final String NO_AI_NAME = "no_ai";
    private static final String XP = "xp";
    private static final String RESULT_NAME = "result";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder pack = Commands.m_82127_((String)MAID_NAME);
        RequiredArgumentBuilder targets = Commands.m_82129_((String)TARGETS_NAME, (ArgumentType)EntityArgument.m_91449_());
        LiteralArgumentBuilder noAi = Commands.m_82127_((String)NO_AI_NAME);
        LiteralArgumentBuilder xp = Commands.m_82127_((String)XP);
        RequiredArgumentBuilder booleanResult = Commands.m_82129_((String)RESULT_NAME, (ArgumentType)BoolArgumentType.bool());
        RequiredArgumentBuilder intResult = Commands.m_82129_((String)RESULT_NAME, (ArgumentType)IntegerArgumentType.integer());
        pack.then(targets.then(noAi.then(booleanResult.executes(MaidCommand::handleMaidNoAi))));
        pack.then(targets.then(xp.then(intResult.executes(MaidCommand::handleMaidXp))));
        return pack;
    }

    private static int handleMaidNoAi(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)TARGETS_NAME);
        boolean noAi = BoolArgumentType.getBool(context, (String)RESULT_NAME);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            maid.m_21557_(noAi);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.touhou_little_maid.maid.no_ai.success", (Object[])new Object[]{String.valueOf(noAi)}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.touhou_little_maid.maid.not_maid"));
        }
        return 1;
    }

    private static int handleMaidXp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)TARGETS_NAME);
        int xpCount = IntegerArgumentType.getInteger(context, (String)RESULT_NAME);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            maid.setExperience(xpCount);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.touhou_little_maid.maid.xp.success", (Object[])new Object[]{String.valueOf(xpCount)}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.touhou_little_maid.maid.not_maid"));
        }
        return 1;
    }
}

