/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.event;

import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GunHurtMaidEvent {
    @SubscribeEvent
    public void onMaidHurt(MaidHurtEvent event) {
        DamageSource source = event.getSource();
        EntityMaid maid = event.getMaid();
        if (maid.m_21805_() == null) {
            return;
        }
        if (this.isBulletDamage(source)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGunHurt(ProjectileHitEvent.HitEntity event) {
        Entity hurtEntity = event.getTarget();
        Entity attacker = event.getOwner();
        if (attacker instanceof EntityMaid) {
            Player player;
            EntityMaid maid = (EntityMaid)attacker;
            if (hurtEntity instanceof Player && maid.m_7307_((Entity)(player = (Player)hurtEntity))) {
                event.setCanceled(true);
            }
        }
        if (attacker instanceof Player) {
            EntityMaid maid;
            Player player = (Player)attacker;
            if (hurtEntity instanceof EntityMaid && (maid = (EntityMaid)hurtEntity).m_7307_((Entity)player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (entity instanceof Player) {
            EntityMaid maid;
            Entity causingEntity;
            Player player = (Player)entity;
            if (this.isBulletDamage(source) && (causingEntity = source.m_7639_()) instanceof EntityMaid && (maid = (EntityMaid)causingEntity).m_7307_((Entity)player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onExplosionDetonateEvent(ExplosionEvent.Detonate event) {
        Entity entity = event.getExplosion().m_253049_();
        if (entity instanceof ProjectileEntity || entity instanceof FastThrowableProjectile) {
            event.getAffectedEntities().removeIf(e -> e instanceof EntityMaid);
        }
    }

    private boolean isBulletDamage(DamageSource source) {
        if (source.m_269533_(ModTags.DamageTypes.GUN_DAMAGE)) {
            return true;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            Entity directEntity = source.m_7640_();
            return directEntity instanceof ProjectileEntity || directEntity instanceof FastThrowableProjectile;
        }
        return false;
    }
}

