/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.RandomEmoji;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.WaitingChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ChatBubbleManager {
    private final EntityMaid maid;

    public ChatBubbleManager(EntityMaid maid) {
        this.maid = maid;
    }

    public void tick() {
        RandomEmoji.tick(this.maid);
        if (this.maid.f_19797_ % 5 != 0) {
            return;
        }
        boolean update = this.getChatBubbleDataCollection().update();
        if (update) {
            this.forceUpdateChatBubble();
        }
    }

    public ChatBubbleDataCollection getChatBubbleDataCollection() {
        return (ChatBubbleDataCollection)this.maid.m_20088_().m_135370_(EntityMaid.getChatBubbleKey());
    }

    @Nullable
    public IChatBubbleData getChatBubble(long key) {
        return this.getChatBubbleDataCollection().get(key);
    }

    public void removeChatBubble(long key) {
        this.getChatBubbleDataCollection().remove(key);
        this.forceUpdateChatBubble();
    }

    public void forceUpdateChatBubble() {
        this.maid.m_20088_().m_276349_(EntityMaid.getChatBubbleKey(), (Object)this.getChatBubbleDataCollection(), true);
    }

    public long addChatBubble(IChatBubbleData bubble) {
        long key = this.getChatBubbleDataCollection().add(bubble);
        this.forceUpdateChatBubble();
        return key;
    }

    public long addTextChatBubble(String langKey) {
        MutableComponent component = Component.m_237115_((String)langKey);
        return this.addChatBubble(TextChatBubbleData.type2((Component)component));
    }

    public long addTextChatBubbleIfTimeout(String langKey, long previousChatBubbleId) {
        ChatBubbleDataCollection collection = this.getChatBubbleDataCollection();
        if (previousChatBubbleId < 0L || !collection.containsKey(previousChatBubbleId)) {
            return this.addTextChatBubble(langKey);
        }
        return previousChatBubbleId;
    }

    public long addThinkingText(String langKey) {
        MutableComponent component = Component.m_237115_((String)langKey).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC);
        ResourceLocation icon = new ResourceLocation("touhou_little_maid", "textures/entity/chat_bubble/yinyang_orb.png");
        return this.addChatBubble(WaitingChatBubbleData.create(600, IChatBubbleData.TYPE_2, 0, (Component)component, icon));
    }

    public void addLLMChatText(String message, long waitingChatBubbleId) {
        MutableComponent component = Component.m_237113_((String)message);
        TextChatBubbleData textChatBubble = TextChatBubbleData.type2((Component)component);
        this.getChatBubbleDataCollection().remove(waitingChatBubbleId);
        this.getChatBubbleDataCollection().add(textChatBubble);
        this.forceUpdateChatBubble();
        LivingEntity livingEntity = this.maid.m_269323_();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Component name = this.maid.m_7755_();
            MutableComponent msg = Component.m_237113_((String)"<").m_7220_(name).m_130946_(">").m_7220_(CommonComponents.f_263701_).m_130946_(message);
            player.m_213846_((Component)msg.m_130940_(ChatFormatting.GRAY));
        }
    }
}

