/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.binding.ContextBinding;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.BiomeHasAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.BiomeHasAnyTag;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EmptyFunction;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EquippedItemAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EquippedItemAnyTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemMaxDurability;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemNameAny;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemRemainingDurability;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.Position;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.PositionDelta;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.RelativeBlockHasAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.RelativeBlockHasAnyTag;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import com.github.tartaricacid.touhoulittlemaid.util.EquipmentUtil;
import net.minecraft.client.CameraType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;

public class QueryBinding
extends ContextBinding {
    public static final QueryBinding INSTANCE = new QueryBinding();

    private QueryBinding() {
        this.function("biome_has_all_tags", new BiomeHasAllTags());
        this.function("biome_has_any_tag", new BiomeHasAnyTag());
        this.function("relative_block_has_all_tags", new RelativeBlockHasAllTags());
        this.function("relative_block_has_any_tag", new RelativeBlockHasAnyTag());
        this.function("is_item_name_any", new ItemNameAny());
        this.function("equipped_item_all_tags", new EquippedItemAllTags());
        this.function("equipped_item_any_tag", new EquippedItemAnyTags());
        this.function("position", new Position());
        this.function("position_delta", new PositionDelta());
        this.function("max_durability", new ItemMaxDurability());
        this.function("remaining_durability", new ItemRemainingDurability());
        this.var("actor_count", ctx -> ctx.level().m_104813_());
        this.var("anim_time", ctx -> ctx.animationControllerContext().animTime());
        this.var("life_time", ctx -> ctx.geoInstance().getSeekTime() / 20.0);
        this.var("head_x_rotation", ctx -> Float.valueOf(ctx.data().netHeadYaw));
        this.var("head_y_rotation", ctx -> Float.valueOf(ctx.data().headPitch));
        this.var("moon_phase", ctx -> ctx.level().m_46941_());
        this.var("time_of_day", ctx -> Float.valueOf(MolangUtils.normalizeTime(ctx.level().m_46468_())));
        this.var("time_stamp", ctx -> ctx.level().m_46468_());
        this.entityVar("yaw_speed", ctx -> Float.valueOf(QueryBinding.getYawSpeed((Entity)ctx.entity())));
        this.entityVar("cardinal_facing_2d", ctx -> ((Entity)ctx.entity()).m_6350_().m_122411_());
        this.entityVar("distance_from_camera", ctx -> ctx.mc().f_91063_.m_109153_().m_90583_().m_82554_(((Entity)ctx.entity()).m_20182_()));
        this.entityVar("eye_target_x_rotation", ctx -> Float.valueOf(((Entity)ctx.entity()).m_5686_(ctx.animationEvent().getPartialTick())));
        this.entityVar("eye_target_y_rotation", ctx -> Float.valueOf(((Entity)ctx.entity()).m_5675_(ctx.animationEvent().getPartialTick())));
        this.entityVar("ground_speed", ctx -> Float.valueOf(QueryBinding.getGroundSpeed((Entity)ctx.entity())));
        this.entityVar("modified_distance_moved", ctx -> Float.valueOf(((Entity)ctx.entity()).f_19787_));
        this.entityVar("vertical_speed", ctx -> Float.valueOf(QueryBinding.getVerticalSpeed((Entity)ctx.entity())));
        this.entityVar("walk_distance", ctx -> Float.valueOf(((Entity)ctx.entity()).f_19788_));
        this.entityVar("has_rider", ctx -> ((Entity)ctx.entity()).m_20160_());
        this.entityVar("is_first_person", ctx -> ctx.mc().f_91066_.m_92176_() == CameraType.FIRST_PERSON);
        this.entityVar("is_in_water", ctx -> ((Entity)ctx.entity()).m_20069_());
        this.entityVar("is_in_water_or_rain", ctx -> ((Entity)ctx.entity()).m_20071_());
        this.entityVar("is_on_fire", ctx -> ((Entity)ctx.entity()).m_6060_());
        this.entityVar("is_on_ground", ctx -> ((Entity)ctx.entity()).m_20096_());
        this.entityVar("is_riding", ctx -> ((Entity)ctx.entity()).m_20159_());
        this.entityVar("is_sneaking", ctx -> ((Entity)ctx.entity()).m_20096_() && ((Entity)ctx.entity()).m_20089_() == Pose.CROUCHING);
        this.entityVar("is_spectator", ctx -> ((Entity)ctx.entity()).m_5833_());
        this.entityVar("is_sprinting", ctx -> ((Entity)ctx.entity()).m_20142_());
        this.entityVar("is_swimming", ctx -> ((Entity)ctx.entity()).m_6069_());
        this.livingEntityVar("body_x_rotation", ctx -> Float.valueOf(Mth.m_14179_((float)ctx.animationEvent().getPartialTick(), (float)((LivingEntity)ctx.entity()).f_19860_, (float)((LivingEntity)ctx.entity()).m_146909_())));
        this.livingEntityVar("body_y_rotation", ctx -> Float.valueOf(Mth.m_14177_((float)Mth.m_14179_((float)ctx.animationEvent().getPartialTick(), (float)((LivingEntity)ctx.entity()).f_20884_, (float)((LivingEntity)ctx.entity()).f_20883_))));
        this.livingEntityVar("health", ctx -> Float.valueOf(((LivingEntity)ctx.entity()).m_21223_()));
        this.livingEntityVar("max_health", ctx -> Float.valueOf(((LivingEntity)ctx.entity()).m_21233_()));
        this.livingEntityVar("hurt_time", ctx -> ((LivingEntity)ctx.entity()).f_20916_);
        this.livingEntityVar("is_eating", ctx -> ((LivingEntity)ctx.entity()).m_21211_().m_41780_() == UseAnim.EAT);
        this.livingEntityVar("is_playing_dead", ctx -> ((LivingEntity)ctx.entity()).m_21224_());
        this.livingEntityVar("is_sleeping", ctx -> ((LivingEntity)ctx.entity()).m_5803_());
        this.livingEntityVar("is_using_item", ctx -> ((LivingEntity)ctx.entity()).m_6117_());
        this.livingEntityVar("item_in_use_duration", ctx -> (double)((LivingEntity)ctx.entity()).m_21252_() / 20.0);
        this.livingEntityVar("item_max_use_duration", ctx -> QueryBinding.getMaxUseDuration((LivingEntity)ctx.entity()) / 20.0);
        this.livingEntityVar("item_remaining_use_duration", ctx -> (double)((LivingEntity)ctx.entity()).m_21212_() / 20.0);
        this.livingEntityVar("equipment_count", ctx -> QueryBinding.getEquipmentCount((LivingEntity)ctx.entity()));
        this.function("debug_output", new EmptyFunction());
        this.var("has_cape", ctx -> false);
        this.var("cape_flap_amount", ctx -> 0);
        this.maidEntityVar("player_level", ctx -> ((EntityMaid)ctx.entity()).getExperience());
        this.mobEntityVar("is_jumping", ctx -> !((Mob)ctx.entity()).m_20159_() && !((Mob)ctx.entity()).m_20096_() && !((Mob)ctx.entity()).m_20069_());
    }

    private static int getEquipmentCount(LivingEntity entity) {
        int count = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (!slot.m_254934_() || (stack = EquipmentUtil.getEquippedItem(entity, slot)).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    private static double getMaxUseDuration(LivingEntity player) {
        ItemStack useItem = player.m_21211_();
        if (useItem.m_41619_()) {
            return 0.0;
        }
        return useItem.m_41779_();
    }

    private static float getYawSpeed(Entity entity) {
        return 20.0f * (entity.m_146908_() - entity.f_19859_);
    }

    private static float getGroundSpeed(Entity player) {
        Vec3 velocity = player.m_20184_();
        return 20.0f * Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
    }

    private static float getVerticalSpeed(Entity entity) {
        return 20.0f * (float)(entity.m_20182_().f_82480_ - entity.f_19855_);
    }
}

