/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container;

import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class MaidMainContainer
extends AbstractMaidContainer {
    protected static final int PLAYER_INVENTORY_SIZE = 36;
    protected static final ResourceLocation EMPTY_MAINHAND_SLOT = new ResourceLocation("item/empty_slot_sword");
    protected static final ResourceLocation EMPTY_BACK_SHOW_SLOT = new ResourceLocation("touhou_little_maid", "slot/empty_back_show_slot");
    protected static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    protected static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public MaidMainContainer(MenuType<?> type, int id, Inventory inventory, int entityId) {
        super(type, id, inventory, entityId);
        if (this.maid != null) {
            this.addMaidArmorInv();
            this.addMaidHandInv();
            this.addMainDefaultInv();
            this.addBackpackInv(inventory);
        }
    }

    protected void addMaidHandInv() {
        LazyOptional hand = this.maid.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        hand.ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 87, 77){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_MAINHAND_SLOT);
            }
        }));
        hand.ifPresent(handler -> this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 121, 77){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        }));
    }

    protected void addMaidArmorInv() {
        LazyOptional armor = this.maid.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.EAST);
        armor.ifPresent(handler -> {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    final EquipmentSlot equipmentSlot = SLOT_IDS[2 * i + j];
                    this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3 - 2 * i - j, 94 + 20 * j, 37 + 20 * i){

                        public int m_6641_() {
                            return 1;
                        }

                        public boolean m_5857_(@Nonnull ItemStack stack) {
                            return stack.canEquip(equipmentSlot, (Entity)MaidMainContainer.this.maid) && stack.m_41720_().m_142095_();
                        }

                        public boolean m_8010_(Player playerIn) {
                            ItemStack itemstack = this.m_7993_();
                            boolean curseEnchant = !itemstack.m_41619_() && !playerIn.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)itemstack);
                            return !curseEnchant && super.m_8010_(playerIn);
                        }

                        @OnlyIn(value=Dist.CLIENT)
                        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                            return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[equipmentSlot.m_20749_()]);
                        }
                    });
                }
            }
        });
    }

    protected void addMainDefaultInv() {
        ItemStackHandler inv = this.maid.getMaidInv();
        for (int i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, i, 143 + 18 * i, 37));
            if (i != 5) continue;
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, i, 143 + 18 * i, 37){

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_BACK_SHOW_SLOT);
                }
            });
        }
    }

    protected abstract void addBackpackInv(Inventory var1);

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack1 = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack2 = slot.m_7993_();
            stack1 = stack2.m_41777_();
            if (index < 36 ? !this.m_38903_(stack2, 36, this.f_38839_.size(), false) : !this.m_38903_(stack2, 0, 36, true)) {
                return ItemStack.f_41583_;
            }
            if (stack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack2.m_41613_() == stack1.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack2);
            if (36 <= index && index < 40) {
                EquipmentSlot equipmentSlot = SLOT_IDS[index - 36];
                this.maid.m_21128_(equipmentSlot, stack1);
            }
            if (40 <= index && index < 42) {
                int slotIndex = index - 36 - 4;
                EquipmentSlot equipmentSlot = slotIndex == 0 ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                this.maid.m_21168_(equipmentSlot, stack1);
            }
        }
        return stack1;
    }
}

