/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BaubleContainer
extends MaidMainContainer {
    public static final MenuType<BaubleContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new BaubleContainer(windowId, inv, data.readInt()));

    public BaubleContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
    }

    public static MenuProvider create(final EntityMaid maid) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Bauble Container");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory inventory, Player player) {
                int entityId = maid.m_19879_();
                return new BaubleContainer(index, inventory, entityId);
            }
        };
    }

    @Override
    protected void addMainDefaultInv() {
    }

    @Override
    protected void addBackpackInv(Inventory inventory) {
        int level = this.maid.getFavorabilityManager().getLevel();
        for (int y = 0; !(y >= 6 || level <= 1 && y >= 2 || level == 2 && y >= 4); ++y) {
            for (int x = 0; x < 5; ++x) {
                int index = x + y * 5;
                this.m_38897_((Slot)new BaubleSlot(this.maid, index, 152 + 18 * x, 45 + 18 * y));
            }
        }
    }

    public static class BaubleSlot
    extends SlotItemHandler {
        private final EntityMaid maid;

        public BaubleSlot(EntityMaid maid, int index, int xPosition, int yPosition) {
            super((IItemHandler)maid.getMaidBauble(), index, xPosition, yPosition);
            this.maid = maid;
        }

        public void m_142406_(Player player, ItemStack stack) {
            IMaidBauble bauble;
            super.m_142406_(player, stack);
            if (!this.maid.f_19853_.f_46443_ && !stack.m_41619_() && (bauble = BaubleManager.getBauble(stack)) != null) {
                bauble.onTakeOff(this.maid, stack);
            }
        }

        public void m_269060_(ItemStack stack) {
            IMaidBauble bauble;
            super.m_269060_(stack);
            if (!this.maid.f_19853_.f_46443_ && !stack.m_41619_() && (bauble = BaubleManager.getBauble(stack)) != null) {
                bauble.onPutOn(this.maid, stack);
            }
        }
    }
}

