/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.handler;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BaubleItemHandler
extends ItemStackHandler {
    private final Int2ObjectSortedMap<IMaidBauble> baubles = new Int2ObjectRBTreeMap();

    public BaubleItemHandler() {
        this(1);
    }

    public BaubleItemHandler(int size) {
        super(size);
    }

    public BaubleItemHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
        IntStream.range(0, this.getSlots()).forEach(this::onContentsChanged);
    }

    private void setBaubleInSlot(int slot, @Nullable IMaidBauble bauble) {
        this.validateSlotIndex(slot);
        if (bauble == null) {
            this.baubles.remove(slot);
        } else {
            this.baubles.put(slot, (Object)bauble);
        }
    }

    @Nullable
    public IMaidBauble getBaubleInSlot(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.m_41619_()) {
            return null;
        }
        return (IMaidBauble)this.baubles.get(slot);
    }

    protected void onContentsChanged(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.m_41619_()) {
            this.setBaubleInSlot(slot, null);
        } else {
            this.setBaubleInSlot(slot, BaubleManager.getBauble(stack));
        }
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return BaubleManager.getBauble(stack) != null;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isItemValid(slot, stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    protected void onLoad() {
        IntStream.range(0, this.getSlots()).forEach(this::onContentsChanged);
    }

    public boolean fireEvent(BiPredicate<IMaidBauble, ItemStack> function) {
        ObjectBidirectionalIterator iterator = this.baubles.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            int slot = entry.getIntKey();
            IMaidBauble bauble = (IMaidBauble)entry.getValue();
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (!function.test(bauble, stack)) continue;
            return true;
        }
        return false;
    }

    public int getBaubleSlot(IMaidBauble bauble) {
        for (Int2ObjectMap.Entry entry : this.baubles.int2ObjectEntrySet()) {
            if (entry.getValue() != bauble) continue;
            return entry.getIntKey();
        }
        return -1;
    }
}

