/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.opus;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.HighLevelOggStreamPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.IOUtils;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.opus.OpusAudioData;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.opus.OpusInfo;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.opus.OpusPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.opus.OpusTags;

public class OpusPacketFactory
extends HighLevelOggStreamPacket {
    public static boolean isOpusStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return OpusPacketFactory.isOpusSpecial(firstPacket);
    }

    protected static boolean isOpusSpecial(OggPacket packet) {
        byte[] d = packet.getData();
        if (d.length < 12) {
            return false;
        }
        if (IOUtils.byteRangeMatches(OpusPacket.MAGIC_HEADER_BYTES, d, 0)) {
            return true;
        }
        return IOUtils.byteRangeMatches(OpusPacket.MAGIC_TAGS_BYTES, d, 0);
    }

    public static OpusPacket create(OggPacket packet) {
        if (OpusPacketFactory.isOpusSpecial(packet)) {
            byte type = packet.getData()[4];
            switch (type) {
                case 72: {
                    return new OpusInfo(packet);
                }
                case 84: {
                    return new OpusTags(packet);
                }
            }
        }
        return new OpusAudioData(packet);
    }
}

