/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class DismountMessage {
    public static final int DISMOUNT_BROOM = 1;
    private final int action;

    public DismountMessage(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public static DismountMessage decode(FriendlyByteBuf buf) {
        int action = buf.readInt();
        return new DismountMessage(action);
    }

    public static void encode(DismountMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.action);
    }

    public static void handle(DismountMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            context.enqueueWork(() -> DismountMessage.onHandle(message, sender));
        }
        context.setPacketHandled(true);
    }

    private static void onHandle(DismountMessage message, ServerPlayer sender) {
        if (message.getAction() == 1 && sender.m_20202_() instanceof EntityBroom) {
            sender.m_8127_();
        }
    }
}

