/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Search;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.WChessToServerMessage;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class WChessToClientMessage {
    private final BlockPos pos;
    private final String fenData;

    public WChessToClientMessage(BlockPos pos, String fenData) {
        this.pos = pos;
        this.fenData = fenData;
    }

    public static void encode(WChessToClientMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130070_(message.fenData);
    }

    public static WChessToClientMessage decode(FriendlyByteBuf buf) {
        return new WChessToClientMessage(buf.m_130135_(), buf.m_130277_());
    }

    public static void handle(WChessToClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> WChessToClientMessage.onHandle(message), Util.m_183991_()));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(WChessToClientMessage message) {
        int levelTime = 1000;
        long timeStart = System.currentTimeMillis();
        int move = 0;
        Position position = new Position();
        position.fromFen(message.fenData);
        boolean maidLost = WChessUtil.isMaid(position) && position.isMate();
        boolean playerLost = false;
        if (!maidLost) {
            move = new Search(position, 12).searchMain(levelTime);
            playerLost = position.makeMove(move) && WChessUtil.isPlayer(position) && position.isMate();
        }
        long timeRemain = Math.max(0, levelTime - (int)(System.currentTimeMillis() - timeStart));
        try {
            if (timeRemain > 0L) {
                Thread.sleep(timeRemain);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int moveFinal = move;
        boolean playerLostFinal = playerLost;
        Minecraft.m_91087_().m_18689_(() -> NetworkHandler.CHANNEL.sendToServer((Object)new WChessToServerMessage(message.pos, moveFinal, maidLost, playerLostFinal)));
    }
}

