/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.function.implement;

import com.github.tartaricacid.touhoulittlemaid.ai.service.function.IFunctionCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.response.ToolResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.ObjectParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.Parameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.StringParameter;
import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class SwitchAttackTaskFunction
implements IFunctionCall<Result> {
    private static final String FUNCTION_ID = "switch_maid_attack_task";
    private static final String FUNCTION_DESC = "Use this function to change the maid's current combat or behavior task.\nEspecially when the user asks to alter her fighting style, prepare for a battle, or stand down";
    private static final String TASK_ID_PARAMETER_ID = "task_id";
    private static final String TASK_ID_PARAMETER_DESC = "task_id (string, required): The specific ID of the task you want the maid to switch to. Available tasks include:\nidle (Stands idle), attack (Melee combat), ranged_attack (Bow combat)\ncrossbow_attack (Crossbow combat), danmaku_attack (Danmaku combat), trident_attack (Trident combat)";
    private static final String GUN_TASK_ID_PARAMETER_DESC = "gun_attack (Gun combat)";
    private static final String SUCCESS = "Successfully switched to %s task";
    private static final String MISSING = "Successfully switched to %s task, but the corresponding weapon is missing";
    private static final String FAIL = "Switch failed and there is no task named %s";
    private static final String NO_CHANGE = "You're currently in %s task and don't need to switch";

    @Override
    public String getId() {
        return FUNCTION_ID;
    }

    @Override
    public String getDescription(EntityMaid maid) {
        return FUNCTION_DESC;
    }

    @Override
    public Parameter addParameters(ObjectParameter root, EntityMaid maid) {
        StringParameter taskId = StringParameter.create().setDescription(TASK_ID_PARAMETER_DESC).addEnumValues("idle", "attack", "ranged_attack", "crossbow_attack", "danmaku_attack", "trident_attack");
        if (GunCommonUtil.isInstalled()) {
            ((Parameter)taskId).setDescription("task_id (string, required): The specific ID of the task you want the maid to switch to. Available tasks include:\nidle (Stands idle), attack (Melee combat), ranged_attack (Bow combat)\ncrossbow_attack (Crossbow combat), danmaku_attack (Danmaku combat), trident_attack (Trident combat)\ngun_attack (Gun combat)");
            ((Parameter)taskId).addEnumValues("gun_attack");
        }
        root.addProperties(TASK_ID_PARAMETER_ID, taskId);
        return root;
    }

    @Override
    public Codec<Result> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf(TASK_ID_PARAMETER_ID).forGetter(Result::id)).apply((Applicative)instance, Result::new));
    }

    @Override
    public ToolResponse onToolCall(Result result, EntityMaid maid) {
        String id = result.id;
        ResourceLocation taskId = new ResourceLocation("touhou_little_maid", id);
        Optional<IMaidTask> optional = TaskManager.findTask(taskId);
        if (optional.isEmpty()) {
            return new ToolResponse(FAIL.formatted(id));
        }
        IMaidTask task = optional.get();
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        if (task == TaskManager.getIdleTask()) {
            this.putItemBack(maid, backpack);
            maid.setTask(task);
            return new ToolResponse(SUCCESS.formatted(id));
        }
        if (!(task instanceof IAttackTask)) {
            return new ToolResponse(FAIL.formatted(id));
        }
        IAttackTask attackTask = (IAttackTask)task;
        IMaidTask currentTask = maid.getTask();
        if (attackTask == currentTask && attackTask.isWeapon(maid, maid.m_21205_())) {
            return new ToolResponse(NO_CHANGE.formatted(id));
        }
        maid.setTask(task);
        int slot = ItemsUtil.findStackSlot((IItemHandler)backpack, item -> attackTask.isWeapon(maid, (ItemStack)item));
        if (slot >= 0) {
            int count = backpack.getStackInSlot(slot).m_41613_();
            ItemStack output = backpack.extractItem(slot, count, false);
            if (!maid.m_21205_().m_41619_()) {
                ItemStack mainhand = maid.m_21205_();
                backpack.setStackInSlot(slot, mainhand);
            }
            maid.m_21008_(InteractionHand.MAIN_HAND, output);
            return new ToolResponse(SUCCESS.formatted(id));
        }
        return new ToolResponse(MISSING.formatted(id));
    }

    private void putItemBack(EntityMaid maid, RangedWrapper backpack) {
        if (maid.m_21205_().m_41619_()) {
            return;
        }
        ItemStack mainHandItem = maid.m_21205_();
        for (int i = 0; i < backpack.getSlots(); ++i) {
            ItemStack stackInSlot = backpack.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) continue;
            backpack.setStackInSlot(i, mainHandItem);
            maid.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            return;
        }
    }

    public record Result(String id) {
    }
}

