/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.util.VoxelShapeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockScarecrow
extends HorizontalDirectionalBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape LOWER_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)4.5, (double)8.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5)});
    protected static final VoxelShape UPPER_AABB_NORTH = Block.m_49796_((double)4.0, (double)0.0, (double)7.5, (double)12.0, (double)7.5, (double)13.5);
    protected static final VoxelShape UPPER_AABB_SOUTH = VoxelShapeUtils.rotateHorizontal(UPPER_AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape UPPER_AABB_EAST = VoxelShapeUtils.rotateHorizontal(UPPER_AABB_NORTH, Direction.EAST);
    protected static final VoxelShape UPPER_AABB_WEST = VoxelShapeUtils.rotateHorizontal(UPPER_AABB_NORTH, Direction.WEST);

    public BlockScarecrow() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56740_).m_60918_(SoundType.f_56740_).m_60978_(0.2f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean isUpper;
        DoubleBlockHalf currentHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        boolean isLower = currentHalf == DoubleBlockHalf.LOWER && direction == Direction.UP;
        boolean bl = isUpper = currentHalf == DoubleBlockHalf.UPPER && direction == Direction.DOWN;
        if (isLower || isUpper) {
            if (neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != currentHalf) {
                return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)((Direction)neighborState.m_61143_((Property)f_54117_)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos belowPos;
        BlockState belowState;
        DoubleBlockHalf half;
        if (!level.f_46443_ && player.m_7500_() && (half = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.UPPER && (belowState = level.m_8055_(belowPos = pos.m_7495_())).m_60713_(state.m_60734_()) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState empty = belowState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(belowPos, empty, 35);
            level.m_5898_(player, 2001, belowPos, Block.m_49956_((BlockState)belowState));
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        BlockPos abovePos = clickedPos.m_7494_();
        if (clickedPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(abovePos).m_60629_(context)) {
            Direction horizontalDirection = context.m_8125_();
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)horizontalDirection)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, f_54117_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        DoubleBlockHalf blockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (blockHalf == DoubleBlockHalf.LOWER) {
            return LOWER_AABB;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch (direction) {
            case SOUTH: {
                return UPPER_AABB_SOUTH;
            }
            case EAST: {
                return UPPER_AABB_EAST;
            }
            case WEST: {
                return UPPER_AABB_WEST;
            }
        }
        return UPPER_AABB_NORTH;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        int range = (Integer)MiscConfig.SCARECROW_RANGE.get();
        tooltip.add((Component)Component.m_237110_((String)"tooltips.touhou_little_maid.scarecrow.desc", (Object[])new Object[]{range, range}).m_130940_(ChatFormatting.GRAY));
    }
}

