/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBed;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class TileEntityMaidBedRenderer
implements BlockEntityRenderer<TileEntityMaidBed> {
    private final BlockEntityRendererProvider.Context context;
    private final Function<DyeColor, SimpleBedrockModel<?>> cacheModel = Util.m_143827_(color -> {
        ResourceLocation id = new ResourceLocation("touhou_little_maid", "bedrock/block/maid_bed/" + color.m_41065_());
        return BedrockModelLoader.getModel(id);
    });
    private final Function<DyeColor, ResourceLocation> cacheTexture = Util.m_143827_(color -> new ResourceLocation("touhou_little_maid", "textures/bedrock/block/maid_bed/" + color.m_41065_() + ".png"));

    public TileEntityMaidBedRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(TileEntityMaidBed bed, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        DyeColor dyeColor = bed.getColor();
        SimpleBedrockModel<?> model = this.cacheModel.apply(dyeColor);
        ResourceLocation texture = this.cacheTexture.apply(dyeColor);
        poseStack.m_85836_();
        int rotation = ((Direction)bed.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122416_();
        poseStack.m_272245_(Axis.f_252392_.m_252977_((float)(rotation * 90)), 0.5f, 0.0f, 0.5f);
        poseStack.m_85837_(0.5, 1.5, -0.5);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexConsumer = dyeColor == DyeColor.BLUE ? buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture)) : buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
        model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(TileEntityMaidBed pBlockEntity) {
        return true;
    }
}

