/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.listener;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;

public class EmojiReloadListener
implements ResourceManagerReloadListener {
    private static final List<EmojiResource> EMOJI_RESOURCES = Lists.newArrayList();
    private static final String EMOJI_PATH = "textures/chat_bubble/maid_emoji";
    private static final Random RANDOM = new Random();
    private static final int MIN_SIZE = 8;
    private static final int MAX_SIZE = 256;

    public void m_6213_(ResourceManager resourceManager) {
        Set paths = resourceManager.m_214159_(EMOJI_PATH, EmojiReloadListener::filterEmojiResource).keySet();
        EMOJI_RESOURCES.clear();
        paths.forEach(res -> EMOJI_RESOURCES.add(EmojiResource.parse(res)));
    }

    public static boolean filterEmojiResource(ResourceLocation res) {
        String path = res.m_135815_();
        return path.endsWith(".png") || path.endsWith(".gif");
    }

    public static Optional<EmojiResource> getRandomEmojis() {
        if (EMOJI_RESOURCES.isEmpty()) {
            return Optional.empty();
        }
        int index = RANDOM.nextInt(EMOJI_RESOURCES.size());
        return Optional.ofNullable(EMOJI_RESOURCES.get(index));
    }

    public record EmojiResource(ResourceLocation location, Format format, int width, int height) {
        private static final Pattern SIZE_PATTERN = Pattern.compile("^.*?-(\\d+)x(\\d+)\\.(png|gif)$");

        public static EmojiResource parse(ResourceLocation res) {
            Format format;
            String path = res.m_135815_();
            Matcher matcher = SIZE_PATTERN.matcher(path);
            Format format2 = format = path.endsWith(".gif") ? Format.GIF : Format.PNG;
            if (matcher.matches()) {
                int width = Integer.parseInt(matcher.group(1));
                int height = Integer.parseInt(matcher.group(2));
                width = Mth.m_14045_((int)width, (int)8, (int)256);
                height = Mth.m_14045_((int)height, (int)8, (int)256);
                return new EmojiResource(res, format, width, height);
            }
            return new EmojiResource(res, format, 24, 24);
        }

        public boolean isGif() {
            return this.format == Format.GIF;
        }
    }

    static enum Format {
        PNG,
        GIF;

    }
}

