/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util;

public class RateLimiter {
    private final float interval;
    private float aggregate;
    private float lastRequestTime;

    public RateLimiter(int limitPerSec) {
        this.aggregate = this.interval = 1.0f / (float)limitPerSec;
        this.lastRequestTime = 0.0f;
    }

    public boolean request(float time) {
        this.aggregate += time - this.lastRequestTime;
        this.lastRequestTime = time;
        if (this.aggregate < this.interval) {
            return false;
        }
        this.aggregate %= this.interval;
        return true;
    }
}

