/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.runtime;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.AssignableVariableExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.BinaryExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.CallExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.DoubleExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExecutionScopeExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.IdentifierExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.StatementExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.StringExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.StructAccessExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.TernaryConditionalExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.UnaryExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.VariableExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.AssignableVariable;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.ExpressionEvaluator;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.Function;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.HashMapStruct;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.Struct;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.binding.ValueConversions;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionEvaluatorImpl<TEntity>
implements ExpressionEvaluator<TEntity> {
    private static final Evaluator[] BINARY_EVALUATORS = new Evaluator[]{ExpressionEvaluatorImpl.bool((a, b) -> a.eval() && b.eval()), ExpressionEvaluatorImpl.bool((a, b) -> a.eval() || b.eval()), ExpressionEvaluatorImpl.compare((a, b) -> a.eval() < b.eval()), ExpressionEvaluatorImpl.compare((a, b) -> a.eval() <= b.eval()), ExpressionEvaluatorImpl.compare((a, b) -> a.eval() > b.eval()), ExpressionEvaluatorImpl.compare((a, b) -> a.eval() >= b.eval()), (evaluator, a, b) -> {
        Object aVal = a.visit(evaluator);
        Object bVal = b.visit(evaluator);
        return Float.valueOf(ValueConversions.asFloat(aVal) + ValueConversions.asFloat(bVal));
    }, ExpressionEvaluatorImpl.arithmetic((a, b) -> a.eval() - b.eval()), ExpressionEvaluatorImpl.arithmetic((a, b) -> a.eval() * b.eval()), ExpressionEvaluatorImpl.arithmetic((a, b) -> {
        float dividend = a.eval();
        float divisor = b.eval();
        if (divisor == 0.0f) {
            return 0.0f;
        }
        return dividend / divisor;
    }), (evaluator, a, b) -> {
        Object val = a.visit(evaluator);
        if (val == null) {
            return null;
        }
        return b.visit(evaluator.createChild(val));
    }, (evaluator, a, b) -> {
        Object val = a.visit(evaluator);
        if (val == null) {
            return b.visit(evaluator);
        }
        return val;
    }, (evaluator, a, b) -> {
        Object val = b.visit(evaluator);
        if (a instanceof AssignableVariableExpression) {
            AssignableVariable var = ((AssignableVariableExpression)a).target();
            if (val instanceof Struct) {
                val = ((Struct)val).copy();
            }
            var.assign(evaluator, val);
        } else if (a instanceof StructAccessExpression) {
            if (val instanceof Struct) {
                return val;
            }
            StructAccessExpression exp = (StructAccessExpression)a;
            Object value = exp.left().visit(evaluator);
            if (value == null) {
                if (exp.left() instanceof AssignableVariableExpression) {
                    AssignableVariable variable = ((AssignableVariableExpression)exp.left()).target();
                    HashMapStruct struct = new HashMapStruct();
                    struct.putProperty(exp.path(), val);
                    variable.assign(evaluator, struct);
                }
            } else if (value instanceof Struct) {
                ((Struct)value).putProperty(exp.path(), val);
            }
        }
        return val;
    }, (evaluator, a, b) -> {
        Object condition = a.visit(evaluator);
        if (ValueConversions.asBoolean(condition)) {
            return b.visit(evaluator);
        }
        return null;
    }, (evaluator, a, b) -> {
        Object right;
        Object left = a.visit(evaluator);
        if (left == (right = b.visit(evaluator))) {
            return true;
        }
        if (right == null) {
            return false;
        }
        if (right instanceof Number) {
            return ValueConversions.asFloat(right) == ValueConversions.asFloat(left);
        }
        if (right instanceof String) {
            return right.equals(left);
        }
        return false;
    }, (evaluator, a, b) -> {
        Object right;
        Object left = a.visit(evaluator);
        if (left == (right = b.visit(evaluator))) {
            return false;
        }
        if (right == null) {
            return true;
        }
        if (right instanceof Number) {
            return ValueConversions.asFloat(right) != ValueConversions.asFloat(left);
        }
        if (right instanceof String) {
            return !right.equals(left);
        }
        return false;
    }};
    private final TEntity entity;
    @Nullable
    private Object returnValue;

    public ExpressionEvaluatorImpl(@Nullable TEntity entity) {
        this.entity = entity;
    }

    private static Evaluator bool(BooleanOperator op) {
        return (evaluator, a, b) -> op.operate(() -> ValueConversions.asBoolean(a.visit(evaluator)), () -> ValueConversions.asBoolean(b.visit(evaluator)));
    }

    private static Evaluator compare(Comparator comp) {
        return (evaluator, a, b) -> comp.compare(() -> ValueConversions.asFloat(a.visit(evaluator)), () -> ValueConversions.asFloat(b.visit(evaluator)));
    }

    private static Evaluator arithmetic(ArithmeticOperator op) {
        return (evaluator, a, b) -> Float.valueOf(op.operate(() -> ValueConversions.asFloat(a.visit(evaluator)), () -> ValueConversions.asFloat(b.visit(evaluator))));
    }

    @Override
    public TEntity entity() {
        return this.entity;
    }

    @Override
    @NotNull
    public <TNewEntity> ExpressionEvaluator<TNewEntity> createChild(@Nullable TNewEntity entity) {
        return new ExpressionEvaluatorImpl<TNewEntity>(entity);
    }

    @Override
    @NotNull
    public ExpressionEvaluator<TEntity> createChild() {
        return new ExpressionEvaluatorImpl<TEntity>(this.entity);
    }

    @Override
    @Nullable
    public Object popReturnValue() {
        Object val = this.returnValue;
        this.returnValue = null;
        return val;
    }

    @Override
    @Nullable
    public Object visitCall(@NotNull CallExpression expression) {
        Function function = expression.function();
        return function.evaluate(this, expression.arguments());
    }

    @Override
    public Object visitDouble(@NotNull DoubleExpression expression) {
        return expression.value();
    }

    @Override
    public Object visitExecutionScope(@NotNull ExecutionScopeExpression executionScope) {
        return this.buildExecutionScopeFunction(executionScope).evaluate(this, Function.EMPTY_ARGUMENT);
    }

    @Override
    public Function buildExecutionScopeFunction(@NotNull ExecutionScopeExpression executionScope) {
        List<Expression> expressions = executionScope.expressions();
        ExpressionEvaluator evaluatorForThisScope = this.createChild();
        return (context, arguments) -> {
            Object lastResult = null;
            for (Expression expression : expressions) {
                lastResult = evaluatorForThisScope.eval(expression);
                Object returnValue = evaluatorForThisScope.popReturnValue();
                if (returnValue == null) continue;
                return returnValue;
            }
            return lastResult;
        };
    }

    @Override
    public Object visitIdentifier(@NotNull IdentifierExpression expression) {
        throw new RuntimeException("Unknown identifier type");
    }

    @Override
    public Object visitVariable(@NotNull VariableExpression expression) {
        return expression.target().evaluate(this);
    }

    @Override
    public Object visitAssignableVariable(@NotNull AssignableVariableExpression expression) {
        return expression.target().evaluate(this);
    }

    @Override
    public Object visitStruct(@NotNull StructAccessExpression expression) {
        Object value = expression.left().visit(this);
        if (value instanceof Struct) {
            return ((Struct)value).getProperty(expression.path());
        }
        return null;
    }

    @Override
    public Object visitBinary(@NotNull BinaryExpression expression) {
        return BINARY_EVALUATORS[expression.op().index()].eval(this, expression.left(), expression.right());
    }

    @Override
    public Object visitUnary(@NotNull UnaryExpression expression) {
        Object value = expression.expression().visit(this);
        switch (expression.op()) {
            case LOGICAL_NEGATION: {
                return !ValueConversions.asBoolean(value);
            }
            case ARITHMETICAL_NEGATION: {
                return Float.valueOf(-ValueConversions.asFloat(value));
            }
            case RETURN: {
                this.returnValue = value;
                return 0.0;
            }
        }
        throw new IllegalStateException("Unknown operation");
    }

    @Override
    public Object visitStatement(@NotNull StatementExpression expression) {
        switch (expression.op()) {
            case BREAK: {
                this.returnValue = StatementExpression.Op.BREAK;
                break;
            }
            case CONTINUE: {
                this.returnValue = StatementExpression.Op.CONTINUE;
            }
        }
        return null;
    }

    @Override
    public Object visitString(@NotNull StringExpression expression) {
        return expression.value();
    }

    @Override
    public Object visitTernaryConditional(@NotNull TernaryConditionalExpression expression) {
        Object obj = expression.condition().visit(this);
        obj = ValueConversions.asBoolean(obj) ? expression.trueExpression().visit(this) : expression.falseExpression().visit(this);
        return obj;
    }

    @Override
    public Object visit(@NotNull Expression expression) {
        throw new UnsupportedOperationException("Unsupported expression type: " + expression);
    }

    private static interface BooleanOperator {
        public boolean operate(LazyEvaluableBoolean var1, LazyEvaluableBoolean var2);
    }

    private static interface Evaluator<TEntity> {
        public Object eval(ExpressionEvaluator<TEntity> var1, Expression var2, Expression var3);
    }

    private static interface Comparator {
        public boolean compare(LazyEvaluableFloat var1, LazyEvaluableFloat var2);
    }

    private static interface ArithmeticOperator {
        public float operate(LazyEvaluableFloat var1, LazyEvaluableFloat var2);
    }

    static interface LazyEvaluableFloat {
        public float eval();
    }

    static interface LazyEvaluableBoolean {
        public boolean eval();
    }
}

