/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityShrine
extends BlockEntity {
    public static final BlockEntityType<TileEntityShrine> TYPE = BlockEntityType.Builder.m_155273_(TileEntityShrine::new, (Block[])new Block[]{(Block)InitBlocks.SHRINE.get()}).m_58966_(null);
    private static final String STORAGE_ITEM = "StorageItem";
    private final ItemStackHandler handler = new ItemStackHandler(){

        protected void onContentsChanged(int slot) {
            TileEntityShrine.this.refresh();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() == InitItems.FILM.get();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public TileEntityShrine(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        this.getPersistentData().m_128365_(STORAGE_ITEM, (Tag)this.handler.serializeNBT());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.handler.deserializeNBT(this.getPersistentData().m_128469_(STORAGE_ITEM));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public ItemStack getStorageItem() {
        return this.handler.getStackInSlot(0);
    }

    public void insertStorageItem(ItemStack stack) {
        this.handler.insertItem(0, stack, false);
    }

    public ItemStack extractStorageItem() {
        return this.handler.extractItem(0, 1, false);
    }

    public boolean isEmpty() {
        return this.handler.getStackInSlot(0).m_41619_();
    }

    public boolean canInsert(ItemStack stack) {
        return this.handler.isItemValid(0, stack);
    }
}

