/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util.http;

import com.google.common.base.Joiner;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class UrlTool {
    public static String buildQueryString(String baseUrl, @Nullable Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return baseUrl;
        }
        StringBuilder query = new StringBuilder();
        query.append(baseUrl);
        if (!baseUrl.contains("?")) {
            query.append("?");
        } else if (!baseUrl.endsWith("&") && !baseUrl.endsWith("?")) {
            query.append("&");
        }
        String paramsText = Joiner.on((String)"&").withKeyValueSeparator("=").join(params.entrySet().stream().collect(UrlTool.escape()));
        query.append(paramsText);
        return query.toString();
    }

    @NotNull
    private static Collector<Map.Entry<String, String>, ?, Map<String, String>> escape() {
        Escaper escaper = UrlEscapers.urlFormParameterEscaper();
        return Collectors.toMap(e -> escaper.escape((String)e.getKey()), e -> escaper.escape((String)e.getValue()));
    }
}

