/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.LLMCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class AutoGenSettingCallback
extends LLMCallback {
    public AutoGenSettingCallback(MaidAIChatManager chatManager, String message, long waitingChatBubbleId) {
        super(chatManager, message, waitingChatBubbleId);
    }

    @Override
    public void onSuccess(ResponseChat responseChat) {
        Level level;
        String result = responseChat.getChatText();
        if (StringUtils.isBlank((CharSequence)result)) {
            this.onFailure(null, new Throwable("Error in Response Chat: %s".formatted(responseChat)), 4);
            return;
        }
        this.chatManager.customSetting = result.replaceAll("\n+", "\n\n");
        LivingEntity owner = this.maid.getOwner();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.chat.llm.auto_gen_setting").withStyle(ChatFormatting.GRAY));
        }
        if ((level = this.maid.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MinecraftServer server = serverLevel.getServer();
            server.submit(() -> {
                this.maid.getChatBubbleManager().removeChatBubble(this.waitingChatBubbleId);
                this.maid.getChatBubbleManager().addTextChatBubble("ai.touhou_little_maid.chat.llm.auto_gen_setting");
            });
        }
    }
}

