/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatSerializable;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.CharacterSetting;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.SettingReader;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SupportModelSelect;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.DefaultLLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.ToolCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.system.TTSSystemSite;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.CappedQueue;
import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class MaidAIChatData
extends MaidAIChatSerializable {
    protected static final String MAID_HISTORY_CHAT_TAG = "MaidHistoryChat";
    protected final EntityMaid maid;
    protected final CappedQueue<LLMMessage> history;

    public MaidAIChatData(EntityMaid maid) {
        this.maid = maid;
        this.history = new CappedQueue((Integer)AIConfig.MAID_MAX_HISTORY_LLM_SIZE.get());
    }

    @Override
    public CompoundTag readFromTag(CompoundTag tag) {
        if (tag.contains(MAID_HISTORY_CHAT_TAG)) {
            try {
                this.history.getDeque().clear();
                LLMMessage.CODEC.listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(MAID_HISTORY_CHAT_TAG)).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0)).ifPresent(list -> {
                    ListIterator iterator = list.listIterator(list.size());
                    while (iterator.hasPrevious()) {
                        this.history.add((LLMMessage)iterator.previous());
                    }
                });
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to parse MaidHistoryChat", (Throwable)e);
            }
        }
        return super.readFromTag(tag);
    }

    @Override
    public CompoundTag writeToTag(CompoundTag tag) {
        if (this.history.size() > 0) {
            try {
                ArrayList llmMessages = Lists.newArrayList(this.history.getDeque());
                LLMMessage.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)llmMessages).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0)).ifPresent(t -> tag.put(MAID_HISTORY_CHAT_TAG, t));
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to parse MaidHistoryChat", (Throwable)e);
            }
        }
        return super.writeToTag(tag);
    }

    @Nullable
    public LLMSite getLLMSite() {
        LLMSite site;
        if (StringUtils.isBlank((CharSequence)this.llmSite)) {
            site = DefaultLLMSite.PLAYER2;
        } else {
            site = AvailableSites.getLLMSite(this.llmSite);
            if (site == null || !site.enabled()) {
                site = DefaultLLMSite.PLAYER2;
            }
        }
        return site;
    }

    @Nullable
    public TTSSite getTTSSite() {
        TTSSite site;
        if (StringUtils.isBlank((CharSequence)this.ttsSite)) {
            site = AvailableSites.getTTSSite(TTSSystemSite.API_TYPE);
        } else {
            site = AvailableSites.getTTSSite(this.ttsSite);
            if (site == null || !site.enabled()) {
                site = AvailableSites.getTTSSite(TTSSystemSite.API_TYPE);
            }
        }
        return site;
    }

    public String getLLMModel() {
        LLMSite site = this.getLLMSite();
        String model = "";
        if (site instanceof SupportModelSelect) {
            SupportModelSelect select = (SupportModelSelect)((Object)site);
            model = StringUtils.isBlank((CharSequence)this.llmModel) ? select.getDefaultModel() : select.getModel(this.llmModel);
        }
        return model;
    }

    public String getTTSModel() {
        TTSSite site = this.getTTSSite();
        String model = "";
        if (site instanceof SupportModelSelect) {
            SupportModelSelect select = (SupportModelSelect)((Object)site);
            model = StringUtils.isBlank((CharSequence)this.ttsModel) ? select.getDefaultModel() : select.getModel(this.ttsModel);
        }
        return model;
    }

    public String getTTSLanguage() {
        if (StringUtils.isNotBlank((CharSequence)this.ttsLanguage)) {
            return this.ttsLanguage;
        }
        return (String)AIConfig.TTS_LANGUAGE.get();
    }

    public CappedQueue<LLMMessage> getHistory() {
        return this.history;
    }

    public void addUserHistory(String message) {
        this.history.add(LLMMessage.userChat(this.maid, message));
    }

    public void addAssistantHistory(String message) {
        this.history.add(LLMMessage.assistantChat(this.maid, message));
    }

    public void addAssistantHistory(String message, List<ToolCall> toolCalls) {
        this.history.add(LLMMessage.assistantChat(this.maid, message, toolCalls));
    }

    public void addToolHistory(String message, String toolCallId) {
        this.history.add(LLMMessage.toolChat(this.maid, message, toolCallId));
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public Optional<CharacterSetting> getSetting() {
        String modelId = this.maid.getModelId();
        return SettingReader.getSetting(modelId);
    }
}

