/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.tts.fishaudio;

import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.Format;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.fishaudio.TTSFishAudioSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.fishaudio.request.OpusBitRate;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.fishaudio.request.TTSFishAudioRequest;
import com.google.common.net.MediaType;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

public class TTSFishAudioClient
implements TTSClient {
    private static final Duration MAX_TIMEOUT = Duration.ofSeconds(20L);
    private final HttpClient httpClient;
    private final TTSFishAudioSite site;

    public TTSFishAudioClient(HttpClient httpClient, TTSFishAudioSite site) {
        this.httpClient = httpClient;
        this.site = site;
    }

    @Override
    public void play(String message, TTSConfig config, ResponseCallback<byte[]> callback) {
        URI url = URI.create(this.site.url());
        String apiKey = this.site.secretKey();
        String model = config.model();
        TTSFishAudioRequest request = TTSFishAudioRequest.create().setReferenceId(model).setFormat(Format.OPUS).setOpusBitrate(OpusBitRate.LOWEST).setText(message);
        HttpRequest.Builder builder = HttpRequest.newBuilder().header("Content-Type", MediaType.JSON_UTF_8.toString()).header("Authorization", "Bearer " + apiKey).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)request))).timeout(MAX_TIMEOUT).uri(url);
        this.site.headers().forEach(builder::header);
        HttpRequest httpRequest = builder.build();
        this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofByteArray()).whenComplete((response, throwable) -> this.handleResponse(callback, (HttpResponse<byte[]>)response, (Throwable)throwable, httpRequest));
    }
}

