/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.event.client;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.resource.GeckoModelLoader;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;

public class DefaultGeckoAnimationEvent
extends Event {
    private final AnimationFile maidAnimationFile;
    private final AnimationFile tacAnimationFile;
    private final AnimationFile chairAnimationFile;

    public DefaultGeckoAnimationEvent(AnimationFile maidAnimationFile, AnimationFile tacAnimationFile, AnimationFile chairAnimationFile) {
        this.maidAnimationFile = maidAnimationFile;
        this.tacAnimationFile = tacAnimationFile;
        this.chairAnimationFile = chairAnimationFile;
    }

    public AnimationFile getMaidAnimationFile() {
        return this.maidAnimationFile;
    }

    public AnimationFile getTacAnimationFile() {
        return this.tacAnimationFile;
    }

    public AnimationFile getChairAnimationFile() {
        return this.chairAnimationFile;
    }

    public void addAnimation(AnimationFile animationFile, ResourceLocation file) {
        try (InputStream stream = Minecraft.getInstance().getResourceManager().open(file);){
            GeckoModelLoader.mergeAnimationFile(stream, animationFile);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to load animation file", (Throwable)e);
        }
    }
}

