/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class BlockJoy
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    protected BlockJoy(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockJoy() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f, 3.0f).forceSolidOn().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected abstract Vec3 sitPosition();

    protected abstract String getTypeName();

    protected abstract int sitYRot();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (worldIn instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)worldIn;
            if (playerIn.getItemInHand(hand).isEmpty() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof TileEntityJoy) {
                TileEntityJoy joy = (TileEntityJoy)blockEntity;
                Entity oldSitEntity = serverLevel.getEntity(joy.getSitId());
                if (oldSitEntity != null && oldSitEntity.isAlive()) {
                    return super.useItemOn(itemStack, state, worldIn, pos, playerIn, hand, hit);
                }
                EntitySit newSitEntity = new EntitySit(worldIn, Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)this.sitPosition().x, (double)this.sitPosition().y, (double)this.sitPosition().z), this.getTypeName(), pos);
                newSitEntity.setYRot(((Direction)state.getValue((Property)FACING)).getOpposite().toYRot() + (float)this.sitYRot());
                worldIn.addFreshEntity((Entity)newSitEntity);
                joy.setSitId(newSitEntity.getUUID());
                joy.setChanged();
                playerIn.startRiding((Entity)newSitEntity);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(itemStack, state, worldIn, pos, playerIn, hand, hit);
    }

    public void startMaidSit(EntityMaid maid, BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof TileEntityJoy) {
                TileEntityJoy joy = (TileEntityJoy)blockEntity;
                Entity oldSitEntity = serverLevel.getEntity(joy.getSitId());
                if (oldSitEntity != null && oldSitEntity.isAlive()) {
                    return;
                }
                EntitySit newSitEntity = new EntitySit(worldIn, Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)this.sitPosition().x, (double)this.sitPosition().y, (double)this.sitPosition().z), this.getTypeName(), pos);
                newSitEntity.setYRot(((Direction)state.getValue((Property)FACING)).getOpposite().toYRot() + (float)this.sitYRot());
                worldIn.addFreshEntity((Entity)newSitEntity);
                joy.setSitId(newSitEntity.getUUID());
                joy.setChanged();
                maid.startRiding(newSitEntity);
            }
        }
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityJoy) {
            ServerLevel serverLevel;
            Entity entity;
            TileEntityJoy joy = (TileEntityJoy)blockEntity;
            if (worldIn instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)worldIn).getEntity(joy.getSitId())) instanceof EntitySit) {
                entity.discard();
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return true;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

