/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.InnerClassify;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.apache.commons.lang3.StringUtils;

public class ConditionalSwing {
    private static final String EMPTY = "";
    private final int preSize;
    private final String idPre;
    private final String tagPre;
    private final String extraPre;
    private final List<ResourceLocation> idTest = Lists.newArrayList();
    private final List<TagKey<Item>> tagTest = Lists.newArrayList();
    private final List<UseAnim> extraTest = Lists.newArrayList();
    private final List<String> innerTest = Lists.newArrayList();

    public ConditionalSwing(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            this.idPre = "swing$";
            this.tagPre = "swing#";
            this.extraPre = "swing:";
            this.preSize = 6;
        } else {
            this.idPre = "swing_offhand$";
            this.tagPre = "swing_offhand#";
            this.extraPre = "swing_offhand:";
            this.preSize = 14;
        }
    }

    public void addTest(String name) {
        if (name.length() <= this.preSize) {
            return;
        }
        String substring = name.substring(this.preSize);
        if (name.startsWith(this.idPre) && ResourceLocationUtil.isValidResourceLocation(substring)) {
            this.idTest.add(ResourceLocation.parse((String)substring));
        }
        if (name.startsWith(this.tagPre) && ResourceLocationUtil.isValidResourceLocation(substring)) {
            this.tagTest.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)substring)));
        }
        if (name.startsWith(this.extraPre)) {
            if (substring.equals(UseAnim.NONE.name().toLowerCase(Locale.US))) {
                return;
            }
            Arrays.stream(UseAnim.values()).filter(a -> a.name().toLowerCase(Locale.US).equals(substring)).findFirst().ifPresent(this.extraTest::add);
            this.innerTest.add(name);
        }
    }

    public String doTest(IMaid maid, InteractionHand hand) {
        if (maid.asEntity().getItemInHand(hand).isEmpty()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, hand);
        if (result.isEmpty()) {
            result = this.doTagTest(maid, hand);
            if (result.isEmpty()) {
                return this.doExtraTest(maid, hand);
            }
            return result;
        }
        return result;
    }

    private String doIdTest(IMaid maid, InteractionHand hand) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemInHand = maid.asEntity().getItemInHand(hand);
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)itemInHand.getItem());
        if (registryName == null) {
            return EMPTY;
        }
        if (this.idTest.contains(registryName)) {
            return this.idPre + String.valueOf(registryName);
        }
        return EMPTY;
    }

    private String doTagTest(IMaid maid, InteractionHand hand) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemInHand = maid.asEntity().getItemInHand(hand);
        return this.tagTest.stream().filter(arg_0 -> ((ItemStack)itemInHand).is(arg_0)).findFirst().map(itemTagKey -> this.tagPre + String.valueOf(itemTagKey.location())).orElse(EMPTY);
    }

    private String doExtraTest(IMaid maid, InteractionHand hand) {
        if (this.extraTest.isEmpty() && this.innerTest.isEmpty()) {
            return EMPTY;
        }
        String innerName = InnerClassify.doClassifyTest(this.extraPre, maid, hand);
        if (StringUtils.isNotBlank((CharSequence)innerName) && this.innerTest.contains(innerName)) {
            return innerName;
        }
        UseAnim anim = maid.asEntity().getItemInHand(hand).getUseAnimation();
        if (this.extraTest.contains(anim)) {
            return this.extraPre + anim.name().toLowerCase(Locale.US);
        }
        return EMPTY;
    }
}

