/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;

public class ConditionalVehicle {
    private static final String EMPTY = "";
    private final List<ResourceLocation> idTest = Lists.newArrayList();
    private final List<TagKey<EntityType<?>>> tagTest = Lists.newArrayList();
    private final String idPre;
    private final String tagPre;

    public ConditionalVehicle() {
        this.idPre = "vehicle$";
        this.tagPre = "vehicle#";
    }

    public void addTest(String name) {
        int preSize = this.idPre.length();
        if (name.length() <= preSize) {
            return;
        }
        String substring = name.substring(preSize);
        if (name.startsWith(this.idPre) && ResourceLocationUtil.isValidResourceLocation(substring)) {
            this.idTest.add(ResourceLocation.parse((String)substring));
        }
        if (name.startsWith(this.tagPre) && ResourceLocationUtil.isValidResourceLocation(substring)) {
            this.tagTest.add(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)substring)));
        }
    }

    public String doTest(Mob maid) {
        Entity vehicle = maid.getVehicle();
        if (vehicle == null || !vehicle.isAlive()) {
            return EMPTY;
        }
        String result = this.doIdTest(vehicle);
        if (result.isEmpty()) {
            return this.doTagTest(vehicle);
        }
        return result;
    }

    private String doIdTest(Entity vehicle) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        ResourceLocation registryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)vehicle.getType());
        if (registryName == null) {
            return EMPTY;
        }
        if (this.idTest.contains(registryName)) {
            return this.idPre + String.valueOf(registryName);
        }
        return EMPTY;
    }

    private String doTagTest(Entity vehicle) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        return this.tagTest.stream().filter(tag -> vehicle.getType().is(tag)).findFirst().map(itemTagKey -> this.tagPre + String.valueOf(itemTagKey.location())).orElse(EMPTY);
    }
}

