/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.ServantBellSetPackage;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class ServantBellSetScreen
extends Screen {
    private final int maidId;
    private final UUID maidUuid;
    private EditBox textField;

    public ServantBellSetScreen(EntityMaid maid) {
        super((Component)Component.empty());
        this.maidId = maid.getId();
        this.maidUuid = maid.getUUID();
    }

    protected void init() {
        this.clearWidgets();
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        this.textField = new EditBox(this.getMinecraft().font, middleX - 99, middleY - 26, 200, 20, (Component)Component.translatable((String)"gui.touhou_little_maid.servant_bell.edit_box"));
        this.addWidget((GuiEventListener)this.textField);
        this.setInitialFocus((GuiEventListener)this.textField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), this::sendDoneMessage).pos(middleX - 100, middleY + 10).size(98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).pos(middleX + 4, middleY + 10).size(98, 20).build());
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String value = this.textField.getValue();
        super.resize(minecraft, width, height);
        this.textField.setValue(value);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.textField.render(graphics, mouseX, mouseY, partialTicks);
        if (this.textField.getValue().isEmpty()) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.servant_bell.edit_box").withStyle(ChatFormatting.ITALIC), middleX - 94, middleY - 20, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
        }
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tooltips.touhou_little_maid.servant_bell.uuid", (Object[])new Object[]{this.maidUuid.toString()}), middleX, middleY - 50, 0xFFFFFF);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.textField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.textField);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void insertText(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.setValue(text);
        } else {
            this.textField.insertText(text);
        }
    }

    private void sendDoneMessage(Button button) {
        if (StringUtils.isNotBlank((CharSequence)this.textField.getValue())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServantBellSetPackage(this.maidId, this.textField.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.onClose();
    }
}

