/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class ProgressChatBubbleRenderer
implements IChatBubbleRenderer {
    private static final int MAX_WIDTH = 240;
    private final Font font;
    private final ResourceLocation bg;
    private final List<FormattedCharSequence> split;
    private final int barBackgroundColor;
    private final int barForegroundColor;
    private final double progress;
    private final boolean alignCenter;
    private final int width;
    private final int height;

    public ProgressChatBubbleRenderer(ResourceLocation bg, Component text, int barBackgroundColor, int barForegroundColor, double progress, boolean alignCenter) {
        this.font = Minecraft.getInstance().font;
        this.bg = bg;
        this.split = this.font.split((FormattedText)text, 240);
        this.barBackgroundColor = barBackgroundColor;
        this.barForegroundColor = barForegroundColor;
        this.progress = Mth.clamp((double)progress, (double)0.0, (double)1.0);
        this.alignCenter = alignCenter;
        this.width = Mth.clamp((int)this.font.width((FormattedText)text), (int)100, (int)240);
        int n = this.split.size();
        Objects.requireNonNull(this.font);
        this.height = n * 9 + 12;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        int y = 0;
        for (FormattedCharSequence sequence : this.split) {
            if (this.alignCenter) {
                int distance = this.width - this.font.width(sequence);
                graphics.drawString(this.font, sequence, (float)(distance / 2), (float)y, 0, false);
            } else {
                graphics.drawString(this.font, sequence, 0.0f, (float)y, 0, false);
            }
            Objects.requireNonNull(this.font);
            y += 9;
        }
        int margin = 1;
        int barHeight = 10;
        graphics.fill(0, y += 2, this.width, y + barHeight, this.barBackgroundColor);
        if (this.progress > 0.0) {
            int barWidth = (int)((double)(this.width - 2 * margin) * this.progress);
            graphics.getPoseStack().translate(0.0, 0.0, -0.01);
            graphics.fill(margin, y + margin, barWidth, y + barHeight - margin, this.barForegroundColor);
        }
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.bg;
    }
}

