/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.sound;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.DefaultPackConstant;
import com.github.tartaricacid.touhoulittlemaid.client.sound.OggReader;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.SoundCache;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.SoundData;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class CustomSoundLoader {
    public static final Map<String, SoundCache> CACHE = Maps.newLinkedHashMap();
    private static final Pattern FILENAME_REG = Pattern.compile("^\\d*\\.ogg$");
    private static final Marker MARKER = MarkerManager.getMarker((String)"CustomSoundLoader");
    private static final String JSON_FILE_NAME = "maid_sound.json";

    public static void clear() {
        CACHE.clear();
    }

    public static SoundCache getSoundCache(String id) {
        return CACHE.get(id);
    }

    public static void sortSoundPack() {
        LinkedHashMap sortPacks = Maps.newLinkedHashMap();
        for (String id2 : DefaultPackConstant.SOUND_SORT) {
            if (!CACHE.containsKey(id2)) continue;
            sortPacks.put(id2, CACHE.get(id2));
        }
        CACHE.keySet().stream().filter(id -> !DefaultPackConstant.SOUND_SORT.contains(id)).sorted(String::compareTo).forEach(key -> sortPacks.put(key, CACHE.get(key)));
        CACHE.clear();
        CACHE.putAll(sortPacks);
    }

    public static void loadSoundPack(Path rootPath, String id) {
        File file = rootPath.resolve("assets").resolve(id).resolve(JSON_FILE_NAME).toFile();
        if (!file.isFile()) {
            return;
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Loading {} sound pack: ", (Object)id);
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            SoundPackInfo info = (SoundPackInfo)CustomPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<SoundPackInfo>(){}.getType());
            info.decorate();
            if (info.getIcon() != null) {
                CustomPackLoader.registerFilePackTexture(rootPath, info.getIcon());
            }
            Path soundsFolder = rootPath.resolve("assets").resolve(id).resolve("sounds").resolve("maid");
            SoundCache soundCache = new SoundCache(info, CustomSoundLoader.loadSoundEvent(soundsFolder));
            CACHE.put(id, soundCache);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse sound pack in id {}", (Object)id);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded {} sound pack.", (Object)id);
    }

    private static Map<ResourceLocation, List<SoundData>> loadSoundEvent(Path rootPath) {
        LinkedHashMap buffers = Maps.newLinkedHashMap();
        buffers.put(((SoundEvent)InitSounds.MAID_IDLE.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "idle"));
        buffers.put(((SoundEvent)InitSounds.MAID_ATTACK.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "attack"));
        buffers.put(((SoundEvent)InitSounds.MAID_RANGE_ATTACK.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "range_attack"));
        buffers.put(((SoundEvent)InitSounds.MAID_DANMAKU_ATTACK.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "danmaku_attack"));
        buffers.put(((SoundEvent)InitSounds.MAID_FARM.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "farm"));
        buffers.put(((SoundEvent)InitSounds.MAID_FEED.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "feed"));
        buffers.put(((SoundEvent)InitSounds.MAID_SHEARS.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "shears"));
        buffers.put(((SoundEvent)InitSounds.MAID_MILK.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "milk"));
        buffers.put(((SoundEvent)InitSounds.MAID_TORCH.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "torch"));
        buffers.put(((SoundEvent)InitSounds.MAID_FEED_ANIMAL.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "feed_animal"));
        buffers.put(((SoundEvent)InitSounds.MAID_EXTINGUISHING.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "extinguishing"));
        buffers.put(((SoundEvent)InitSounds.MAID_REMOVE_SNOW.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "snow"));
        buffers.put(((SoundEvent)InitSounds.MAID_BREAK.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "break"));
        buffers.put(((SoundEvent)InitSounds.MAID_FURNACE.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "furnace"));
        buffers.put(((SoundEvent)InitSounds.MAID_BREWING.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "brewing"));
        buffers.put(((SoundEvent)InitSounds.MAID_FIND_TARGET.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "find_target"));
        buffers.put(((SoundEvent)InitSounds.MAID_HURT.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "hurt"));
        buffers.put(((SoundEvent)InitSounds.MAID_HURT_FIRE.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "hurt_fire"));
        buffers.put(((SoundEvent)InitSounds.MAID_PLAYER.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "hurt_player"));
        buffers.put(((SoundEvent)InitSounds.MAID_TAMED.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "tamed"));
        buffers.put(((SoundEvent)InitSounds.MAID_ITEM_GET.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "item_get"));
        buffers.put(((SoundEvent)InitSounds.MAID_DEATH.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "death"));
        buffers.put(((SoundEvent)InitSounds.GAME_WIN.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "game_win"));
        buffers.put(((SoundEvent)InitSounds.GAME_LOST.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("ai"), "game_lost"));
        buffers.put(((SoundEvent)InitSounds.MAID_COLD.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("environment"), "cold"));
        buffers.put(((SoundEvent)InitSounds.MAID_HOT.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("environment"), "hot"));
        buffers.put(((SoundEvent)InitSounds.MAID_RAIN.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("environment"), "rain"));
        buffers.put(((SoundEvent)InitSounds.MAID_SNOW.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("environment"), "snow"));
        buffers.put(((SoundEvent)InitSounds.MAID_MORNING.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("environment"), "morning"));
        buffers.put(((SoundEvent)InitSounds.MAID_NIGHT.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("environment"), "night"));
        buffers.put(((SoundEvent)InitSounds.MAID_CREDIT.get()).getLocation(), CustomSoundLoader.loadSounds(rootPath.resolve("other"), "credit"));
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_ATTACK.get(), (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_ATTACK.get(), (SoundEvent)InitSounds.MAID_DANMAKU_ATTACK.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_FARM.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_FEED.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_SHEARS.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_MILK.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_TORCH.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_FEED_ANIMAL.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_EXTINGUISHING.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_REMOVE_SNOW.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_BREAK.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_FURNACE.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_BREWING.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_HURT.get(), (SoundEvent)InitSounds.MAID_HURT_FIRE.get());
        return buffers;
    }

    private static List<SoundData> loadSounds(Path rootPath, String fileName) {
        ArrayList sounds = Lists.newArrayList();
        File[] files = rootPath.toFile().listFiles((dir, name) -> CustomSoundLoader.checkFileName(fileName, name));
        if (files == null) {
            return sounds;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            OggReader.readSoundDataFromFile(file, sounds, MARKER);
        }
        return sounds;
    }

    private static void reuseSounds(Map<ResourceLocation, List<SoundData>> buffers, SoundEvent from, SoundEvent to) {
        List<SoundData> fromBuffers = buffers.get(from.getLocation());
        buffers.get(to.getLocation()).addAll(fromBuffers);
    }

    private static boolean checkFileName(String patterString, String rawString) {
        if (rawString.startsWith(patterString)) {
            String substring = rawString.substring(patterString.length());
            Matcher matcher = FILENAME_REG.matcher(substring);
            return matcher.matches();
        }
        return false;
    }

    public static void loadSoundPack(ZipFile zipFile, String id) {
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", id, JSON_FILE_NAME));
        if (entry == null) {
            return;
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Loading {} sound pack: ", (Object)id);
        try (InputStream stream = zipFile.getInputStream(entry);){
            SoundPackInfo info = (SoundPackInfo)CustomPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<SoundPackInfo>(){}.getType());
            info.decorate();
            if (info.getIcon() != null) {
                CustomPackLoader.registerZipPackTexture(zipFile.getName(), info.getIcon());
            }
            SoundCache soundCache = new SoundCache(info, CustomSoundLoader.loadSoundEvent(zipFile, id));
            CACHE.put(id, soundCache);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.warn(MARKER, "Fail to parse sound pack in id {}", (Object)id);
            e.printStackTrace();
        }
        TouhouLittleMaid.LOGGER.debug(MARKER, "Loaded {} sound pack.", (Object)id);
    }

    @NotNull
    private static Map<ResourceLocation, List<SoundData>> loadSoundEvent(ZipFile zipFile, String id) {
        LinkedHashMap buffers = Maps.newLinkedHashMap();
        Pattern pattern = Pattern.compile(String.format("assets/%s/sounds/maid/(.*?)/(.*?\\.ogg)", id));
        zipFile.stream().forEach(zipEntry -> {
            String path;
            Matcher matcher;
            if (!zipEntry.isDirectory() && (matcher = pattern.matcher(path = zipEntry.getName())).find()) {
                String subDir = matcher.group(1);
                String fileName = matcher.group(2);
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_IDLE.get(), "mode", "idle");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_ATTACK.get(), "mode", "attack");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get(), "mode", "range_attack");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_DANMAKU_ATTACK.get(), "mode", "danmaku_attack");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_FARM.get(), "mode", "farm");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_FEED.get(), "mode", "feed");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_SHEARS.get(), "mode", "shears");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_MILK.get(), "mode", "milk");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_TORCH.get(), "mode", "torch");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_FEED_ANIMAL.get(), "mode", "feed_animal");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_EXTINGUISHING.get(), "mode", "extinguishing");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_REMOVE_SNOW.get(), "mode", "snow");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_BREAK.get(), "mode", "break");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_FURNACE.get(), "mode", "furnace");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_BREWING.get(), "mode", "brewing");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_FIND_TARGET.get(), "ai", "find_target");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_HURT.get(), "ai", "hurt");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_HURT_FIRE.get(), "ai", "hurt_fire");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_PLAYER.get(), "ai", "hurt_player");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_TAMED.get(), "ai", "tamed");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_ITEM_GET.get(), "ai", "item_get");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_DEATH.get(), "ai", "death");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.GAME_WIN.get(), "ai", "game_win");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.GAME_LOST.get(), "ai", "game_lost");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_COLD.get(), "environment", "cold");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_HOT.get(), "environment", "hot");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_RAIN.get(), "environment", "rain");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_SNOW.get(), "environment", "snow");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_MORNING.get(), "environment", "morning");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_NIGHT.get(), "environment", "night");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, (SoundEvent)InitSounds.MAID_CREDIT.get(), "other", "credit");
            }
        });
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_ATTACK.get(), (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_ATTACK.get(), (SoundEvent)InitSounds.MAID_DANMAKU_ATTACK.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_FARM.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_FEED.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_SHEARS.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_MILK.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_TORCH.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_FEED_ANIMAL.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_EXTINGUISHING.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_REMOVE_SNOW.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_BREAK.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_FURNACE.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_IDLE.get(), (SoundEvent)InitSounds.MAID_BREWING.get());
        CustomSoundLoader.reuseSounds(buffers, (SoundEvent)InitSounds.MAID_HURT.get(), (SoundEvent)InitSounds.MAID_HURT_FIRE.get());
        return buffers;
    }

    private static void loadSounds(ZipFile zipFile, Map<ResourceLocation, List<SoundData>> buffers, ZipEntry zipEntry, String subDir, String fileName, SoundEvent soundEvent, String checkSubDir, String checkFileName) {
        List sounds = buffers.computeIfAbsent(soundEvent.getLocation(), res -> Lists.newArrayList());
        if (checkSubDir.equals(subDir) && CustomSoundLoader.checkFileName(checkFileName, fileName)) {
            OggReader.readSoundDataFromZip(zipFile, zipEntry, fileName, sounds, MARKER);
        }
    }
}

