/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.event;

import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;

public class GunHurtMaidEvent {
    @SubscribeEvent
    public void onMaidHurt(MaidHurtEvent event) {
        DamageSource source = event.getSource();
        EntityMaid maid = event.getMaid();
        if (maid.getOwnerUUID() == null) {
            return;
        }
        if (this.isBulletDamage(source)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGunHurt(ProjectileHitEvent.HitEntity event) {
        Entity hurtEntity = event.getTarget();
        Entity attacker = event.getOwner();
        if (attacker instanceof EntityMaid) {
            Player player;
            EntityMaid maid = (EntityMaid)attacker;
            if (hurtEntity instanceof Player && maid.isAlliedTo((Entity)(player = (Player)hurtEntity))) {
                event.setCanceled(true);
            }
        }
        if (attacker instanceof Player) {
            EntityMaid maid;
            Player player = (Player)attacker;
            if (hurtEntity instanceof EntityMaid && (maid = (EntityMaid)hurtEntity).isAlliedTo((Entity)player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (entity instanceof Player) {
            EntityMaid maid;
            Entity causingEntity;
            Player player = (Player)entity;
            if (this.isBulletDamage(source) && (causingEntity = source.getEntity()) instanceof EntityMaid && (maid = (EntityMaid)causingEntity).isAlliedTo((Entity)player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onExplosionDetonateEvent(ExplosionEvent.Detonate event) {
        Entity entity = event.getExplosion().getDirectSourceEntity();
        if (entity instanceof ProjectileEntity || entity instanceof FastThrowableProjectile) {
            event.getAffectedEntities().removeIf(e -> e instanceof EntityMaid);
        }
    }

    private boolean isBulletDamage(DamageSource source) {
        if (source.is(ModTags.DamageTypes.GUN_DAMAGE)) {
            return true;
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            Entity directEntity = source.getDirectEntity();
            return directEntity instanceof ProjectileEntity || directEntity instanceof FastThrowableProjectile;
        }
        return false;
    }
}

