/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;

public class TacInnerCompat {
    @Nullable
    static ResourceLocation getGunId(ItemStack stack) {
        IGun iGun = IGun.getIGunOrNull((ItemStack)stack);
        if (iGun != null) {
            return iGun.getGunId(stack);
        }
        return null;
    }

    static boolean isGun(ItemStack itemStack) {
        return itemStack.getItem() instanceof IGun;
    }

    static boolean canSee(EntityMaid maid, LivingEntity target) {
        ItemStack handItem = maid.getMainHandItem();
        IGun iGun = IGun.getIGunOrNull((ItemStack)handItem);
        if (iGun == null) {
            return BehaviorUtils.canSee((LivingEntity)maid, (LivingEntity)target);
        }
        ResourceLocation gunId = iGun.getGunId(handItem);
        return TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).map(index -> {
            String type = index.getType();
            String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
            if (sniper.equals(type)) {
                return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            }
            String shotgun = GunTabType.SHOTGUN.name().toLowerCase(Locale.ENGLISH);
            String pistol = GunTabType.PISTOL.name().toLowerCase(Locale.ENGLISH);
            String smg = GunTabType.SMG.name().toLowerCase(Locale.ENGLISH);
            if (shotgun.equals(type) || pistol.equals(type) || smg.equals(type)) {
                return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
            }
            return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
        }).orElse(BehaviorUtils.canSee((LivingEntity)maid, (LivingEntity)target));
    }

    static int performGunAttack(EntityMaid shooter, LivingEntity target, ItemStack gunItem) {
        IGun iGun = IGun.getIGunOrNull((ItemStack)gunItem);
        if (iGun == null) {
            return 100;
        }
        ResourceLocation gunId = iGun.getGunId(gunItem);
        Optional optional = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId);
        if (optional.isEmpty()) {
            return 100;
        }
        CommonGunIndex gunIndex = (CommonGunIndex)optional.get();
        GunData gunData = gunIndex.getGunData();
        double x = target.getX() - shooter.getX();
        double y = target.getEyeY() - shooter.getEyeY();
        double z = target.getZ() - shooter.getZ();
        float yaw = (float)(-Math.toDegrees(Math.atan2(x, z)));
        float pitch = (float)(-Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z))));
        float radius = shooter.getRestrictRadius();
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)shooter);
        ShootResult result = gunOperator.shoot(() -> Float.valueOf(pitch), () -> Float.valueOf(yaw));
        if (result == ShootResult.ID_NOT_EXIST || result == ShootResult.NOT_GUN) {
            return 100;
        }
        String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
        if (gunIndex.getType().equals(sniper) && !gunOperator.getSynIsAiming()) {
            gunOperator.aim(true);
            return Math.round(gunData.getAimTime() * 20.0f) + 2;
        }
        if (!gunIndex.getType().equals(sniper)) {
            float distance = shooter.distanceTo((Entity)target);
            if (distance <= radius && gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
                return Math.round(gunData.getAimTime() * 20.0f) + 2;
            }
            if (distance > radius && !gunOperator.getSynIsAiming()) {
                gunOperator.aim(true);
                return Math.round(gunData.getAimTime() * 20.0f) + 2;
            }
        }
        if (result == ShootResult.NOT_DRAW) {
            gunOperator.draw(() -> ((EntityMaid)shooter).getMainHandItem());
            return Math.round(gunData.getDrawTime() * 20.0f) + 2;
        }
        if (result == ShootResult.NEED_BOLT) {
            gunOperator.bolt();
            return Math.round(gunData.getBoltActionTime() * 20.0f) + 2;
        }
        if (result == ShootResult.NO_AMMO) {
            gunOperator.reload();
            float emptyTime = gunData.getReloadData().getCooldown().getEmptyTime();
            return Math.round(emptyTime * 20.0f) + 2;
        }
        FireMode fireMode = iGun.getFireMode(gunItem);
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST) {
            return 10 + shooter.getRandom().nextInt(5);
        }
        return 2;
    }

    static void stopAim(EntityMaid maid) {
        ItemStack mainHandItem = maid.getMainHandItem();
        IGun iGun = IGun.getIGunOrNull((ItemStack)mainHandItem);
        if (iGun == null) {
            return;
        }
        ResourceLocation gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).ifPresent(gunIndex -> {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)maid);
            if (gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
            }
        });
    }
}

