/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kaleidoscope.crop;

import com.github.tartaricacid.touhoulittlemaid.api.task.ISpecialCropHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.crop.SpecialCropManager;
import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class RiceCropHandler
implements ISpecialCropHandler {
    public static void addCropHandlers(SpecialCropManager manager) {
        RiceCropHandler handler = new RiceCropHandler();
        manager.addSeed((Item)ModItems.RICE_SEED.get(), handler);
        manager.addSeed((Item)ModItems.WILD_RICE_SEED.get(), handler);
        manager.addCrop((Block)ModBlocks.RICE_CROP.get(), handler);
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        int location = (Integer)cropState.getValue((Property)RiceCropBlock.LOCATION);
        return location == 0 && (Integer)cropState.getValue((Property)RiceCropBlock.AGE) >= 7;
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, boolean isDestroyMode) {
        maid.dropResourcesToMaidInv(cropState, maid.level, cropPos, null, maid, maid.getMainHandItem());
        maid.level.levelEvent(2001, cropPos, Block.getId((BlockState)cropState));
        cropState = (BlockState)cropState.setValue((Property)RiceCropBlock.AGE, (Comparable)Integer.valueOf(0));
        maid.level.setBlock(cropPos, cropState, 3);
        maid.level.gameEvent((Entity)maid, (Holder)GameEvent.BLOCK_CHANGE, cropPos);
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        return false;
    }
}

