/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.advancements.altar.AltarCraftTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BaseAdvancement {
    public static void generate(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder root = BaseAdvancement.make((ItemLike)InitItems.HAKUREI_GOHEI.get(), "craft_gohei").requirements(AdvancementRequirements.Strategy.OR).addCriterion("craft_hakurei_gohei", RecipeCraftedTrigger.TriggerInstance.craftedItem((ResourceLocation)BaseAdvancement.id("hakurei_gohei"))).addCriterion("craft_sanae_gohei", RecipeCraftedTrigger.TriggerInstance.craftedItem((ResourceLocation)BaseAdvancement.id("sanae_gohei"))).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, BaseAdvancement.id("base/craft_gohei"), existingFileHelper);
        BaseAdvancement.generateAltar(saver, existingFileHelper, root);
        BaseAdvancement.generateMaid(saver, existingFileHelper, root);
        BaseAdvancement.generateChair(saver, existingFileHelper, root);
    }

    private static void generateChair(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper, AdvancementHolder root) {
        AdvancementHolder chair = BaseAdvancement.make((ItemLike)InitItems.CHAIR.get(), "craft_chair").parent(root).addCriterion("craft_chair", RecipeCraftedTrigger.TriggerInstance.craftedItem((ResourceLocation)BaseAdvancement.id("chair"))).save(saver, BaseAdvancement.id("base/craft_chair"), existingFileHelper);
        BaseAdvancement.make((ItemLike)InitItems.CHANGE_CHAIR_MODEL.get(), "change_chair_model").parent(chair).addCriterion("maid_event", MaidEventTrigger.create("change_chair_model")).save(saver, BaseAdvancement.id("base/change_chair_model"), existingFileHelper);
    }

    private static void generateMaid(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper, AdvancementHolder root) {
        ItemStack stack = ItemEntityPlaceholder.setRecipeId(new ItemStack((ItemLike)InitItems.ENTITY_PLACEHOLDER.get()), "spawn_box");
        AdvancementHolder spawnMaid = BaseAdvancement.make(stack, "spawn_maid").parent(root).addCriterion("altar_craft", AltarCraftTrigger.Instance.recipe(BaseAdvancement.id("altar_recipe/spawn_box"))).rewards(AdvancementRewards.Builder.loot(LootTableGenerator.CAKE)).save(saver, BaseAdvancement.id("base/spawn_maid"), existingFileHelper);
        BaseAdvancement.makeGoal((ItemLike)Items.CAKE, "tamed_maid").parent(spawnMaid).addCriterion("maid_event", MaidEventTrigger.create("tamed_maid")).save(saver, BaseAdvancement.id("base/tamed_maid"), existingFileHelper);
        BaseAdvancement.make((ItemLike)InitItems.CHANGE_MAID_MODEL.get(), "change_maid_model").parent(spawnMaid).addCriterion("maid_event", MaidEventTrigger.create("change_maid_model")).save(saver, BaseAdvancement.id("base/change_maid_model"), existingFileHelper);
        BaseAdvancement.make((ItemLike)Items.JUKEBOX, "change_maid_sound").parent(spawnMaid).addCriterion("maid_event", MaidEventTrigger.create("change_maid_sound")).save(saver, BaseAdvancement.id("base/change_maid_sound"), existingFileHelper);
    }

    private static void generateAltar(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper, AdvancementHolder root) {
        AdvancementHolder altar = BaseAdvancement.make((ItemLike)Items.RED_WOOL, "build_altar").parent(root).addCriterion("maid_event", MaidEventTrigger.create("build_altar")).rewards(AdvancementRewards.Builder.loot(LootTableGenerator.ADVANCEMENT_POWER_POINT)).save(saver, BaseAdvancement.id("base/build_altar"), existingFileHelper);
        EntityPredicate.Builder predicate = EntityPredicate.Builder.entity().of(InitEntities.FAIRY.get());
        BaseAdvancement.make((ItemLike)InitItems.FAIRY_SPAWN_EGG.get(), "kill_maid_fairy").parent(altar).addCriterion("killed_entity", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)predicate)).save(saver, BaseAdvancement.id("base/kill_maid_fairy"), existingFileHelper);
        BaseAdvancement.make((ItemLike)InitItems.POWER_POINT.get(), "pickup_power_point").parent(altar).addCriterion("maid_event", MaidEventTrigger.create("pickup_power_point")).save(saver, BaseAdvancement.id("base/pickup_power_point"), existingFileHelper);
    }

    private static Advancement.Builder make(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.base.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.base.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.TASK, true, true, false);
    }

    private static Advancement.Builder make(ItemStack item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.base.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.base.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.TASK, true, true, false);
    }

    private static Advancement.Builder makeGoal(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.base.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.base.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.GOAL, true, true, false);
    }

    private static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)id);
    }
}

