/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.debug.target;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DebugMaidManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="touhou_little_maid")
@VisibleForDebug
public class SendMaidDebugDataEvent {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player;
        if (!TouhouLittleMaid.DEBUG) {
            return;
        }
        if (event.getEntity().level.isClientSide || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.tickCount % 4 == 0) {
            List<EntityMaid> debuggingMaid = DebugMaidManager.getDebuggingMaid(serverPlayer);
            for (EntityMaid maid : debuggingMaid) {
                SendMaidDebugDataEvent.renderForMaid(maid, serverPlayer);
            }
        }
    }

    private static void renderForMaid(@Nullable EntityMaid maid, ServerPlayer player) {
        Path path;
        if (maid == null) {
            return;
        }
        if (!maid.getNavigation().isDone() && (path = maid.getNavigation().getPath()) != null) {
            player.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new PathfindingDebugPayload(maid.getId(), path, 0.5f)));
        }
        DebugMaidManager.getDebugTargets(maid).forEach(target -> {
            GameTestAddMarkerDebugPayload payload = new GameTestAddMarkerDebugPayload(target.pos(), target.color(), target.text(), target.lifeTime());
            player.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)payload));
        });
    }
}

