/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.sensor;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AABB;

public class MaidNearestLivingEntitySensor
extends Sensor<EntityMaid> {
    protected void doTick(ServerLevel world, EntityMaid maid) {
        AABB aabb = maid.searchDimension();
        List list = world.getEntitiesOfClass(LivingEntity.class, aabb, entity -> entity != maid && entity.isAlive());
        list.sort(Comparator.comparingDouble(arg_0 -> ((EntityMaid)maid).distanceToSqr(arg_0)));
        Brain<EntityMaid> brain = maid.getBrain();
        brain.setMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)list);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)new NearestVisibleLivingEntities((LivingEntity)maid, list));
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }
}

