/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidMoveToBlockTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class MaidFarmMoveTask
extends MaidMoveToBlockTask {
    private final NonNullList<ItemStack> seeds = NonNullList.create();
    private final IFarmTask task;

    public MaidFarmMoveTask(IFarmTask task, float movementSpeed) {
        super(movementSpeed, 2);
        this.task = task;
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeds.clear();
        CombinedInvWrapper inv = entityIn.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.task.isSeed(stack)) continue;
            this.seeds.add((Object)stack);
        }
        this.searchForDestination(worldIn, entityIn);
    }

    @Override
    protected boolean shouldMoveTo(ServerLevel worldIn, EntityMaid maid, BlockPos basePos) {
        BlockState cropState;
        BlockPos above2Pos;
        BlockState stateUp2;
        if (this.task.checkCropPosAbove() && !(stateUp2 = worldIn.getBlockState(above2Pos = basePos.above(2))).getCollisionShape((BlockGetter)worldIn, above2Pos).isEmpty()) {
            return false;
        }
        BlockPos cropPos = basePos.above();
        if (this.task.canHarvest(maid, cropPos, cropState = worldIn.getBlockState(cropPos))) {
            return true;
        }
        BlockState baseState = worldIn.getBlockState(basePos);
        return this.seeds.stream().anyMatch(seed -> this.task.canPlant(maid, basePos, baseState, (ItemStack)seed));
    }
}

