/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.meal.MaidMealManager;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class MaidWorkMealTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;

    public MaidWorkMealTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.setMaxCheckRate(50);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel serverLevel, EntityMaid maid) {
        if (super.checkExtraStartConditions(serverLevel, maid)) {
            String workMealTypeName = Type.WORK_MEAL.getTypeName();
            FavorabilityManager manager = maid.getFavorabilityManager();
            return !maid.isSleeping() && maid.getTask().enableEating(maid) && manager.canAdd(workMealTypeName);
        }
        return false;
    }

    protected void start(ServerLevel serverLevel, EntityMaid maid, long gameTime) {
        List<IMaidMeal> maidMeals = MaidMealManager.getMaidMeals(MaidMealType.WORK_MEAL);
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemInHand = maid.getItemInHand(hand);
            if (itemInHand.isEmpty()) continue;
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, itemInHand, hand)) continue;
                maidMeal.onMaidEat(maid, itemInHand, hand);
                return;
            }
        }
        InteractionHand eanHand = InteractionHand.OFF_HAND;
        for (InteractionHand hand : InteractionHand.values()) {
            if (!maid.getItemInHand(hand).isEmpty()) continue;
            eanHand = hand;
            break;
        }
        ItemStack itemInHand = maid.getItemInHand(eanHand);
        boolean hasFood = false;
        RangedWrapper backpackInv = maid.getAvailableBackpackInv();
        block3: for (int i = 0; i < backpackInv.getSlots(); ++i) {
            ItemStack stack = backpackInv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, stack, eanHand)) continue;
                ItemStack foodStack = backpackInv.extractItem(i, backpackInv.getStackInSlot(i).getCount(), false);
                ItemStack handStack = itemInHand.copy();
                maid.setItemInHand(eanHand, foodStack);
                maid.memoryHandItemStack(handStack);
                itemInHand = maid.getItemInHand(eanHand);
                hasFood = true;
                break block3;
            }
        }
        if (hasFood) {
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, itemInHand, eanHand)) continue;
                maidMeal.onMaidEat(maid, itemInHand, eanHand);
                return;
            }
        }
    }
}

