/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class SetWalkTargetAwayFrom<T>
extends Behavior<PathfinderMob> {
    private final MemoryModuleType<T> walkAwayFromMemory;
    private final float speedModifier;
    private final Function<T, Vec3> toPosition;

    public SetWalkTargetAwayFrom(MemoryModuleType<T> walkAwayFromMemory, float speedModifier, boolean ignoreOtherWalkTarget, Function<T, Vec3> toPosition) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)(ignoreOtherWalkTarget ? MemoryStatus.REGISTERED : MemoryStatus.VALUE_ABSENT), walkAwayFromMemory, (Object)MemoryStatus.VALUE_PRESENT));
        this.walkAwayFromMemory = walkAwayFromMemory;
        this.speedModifier = speedModifier;
        this.toPosition = toPosition;
    }

    public static SetWalkTargetAwayFrom<BlockPos> pos(MemoryModuleType<BlockPos> memoryModuleType, float speedModifier, boolean ignoreOtherWalkTarget) {
        return new SetWalkTargetAwayFrom<BlockPos>(memoryModuleType, speedModifier, ignoreOtherWalkTarget, Vec3::atBottomCenterOf);
    }

    public static SetWalkTargetAwayFrom<? extends Entity> entity(MemoryModuleType<? extends Entity> moduleType, float speedModifier, boolean ignoreOtherWalkTarget) {
        return new SetWalkTargetAwayFrom<Entity>(moduleType, speedModifier, ignoreOtherWalkTarget, Entity::position);
    }

    private static void moveAwayFrom(PathfinderMob mob, Vec3 vec31, float speed) {
        int radius = (int)mob.getRestrictRadius();
        for (int i = 0; i < 10; ++i) {
            Vec3 vec3 = LandRandomPos.getPosAway((PathfinderMob)mob, (int)radius, (int)7, (Vec3)vec31);
            if (vec3 == null) continue;
            mob.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(vec3, speed, 0));
            return;
        }
    }

    public boolean checkExtraStartConditions(ServerLevel pLevel, PathfinderMob pOwner) {
        int radius = (int)pOwner.getRestrictRadius();
        return !this.alreadyWalkingAwayFromPosWithSameSpeed(pOwner) && pOwner.position().closerThan((Position)this.getPosToAvoid(pOwner), (double)radius);
    }

    private Vec3 getPosToAvoid(PathfinderMob mob) {
        return this.toPosition.apply(mob.getBrain().getMemory(this.walkAwayFromMemory).get());
    }

    private boolean alreadyWalkingAwayFromPosWithSameSpeed(PathfinderMob mob) {
        Vec3 vec31;
        if (!mob.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET)) {
            return false;
        }
        WalkTarget walktarget = (WalkTarget)mob.getBrain().getMemory(MemoryModuleType.WALK_TARGET).get();
        if (walktarget.getSpeedModifier() != this.speedModifier) {
            return false;
        }
        Vec3 vec3 = walktarget.getTarget().currentPosition().subtract(mob.position());
        return vec3.dot(vec31 = this.getPosToAvoid(mob).subtract(mob.position())) < 0.0;
    }

    protected void start(ServerLevel pLevel, PathfinderMob pEntity, long pGameTime) {
        SetWalkTargetAwayFrom.moveAwayFrom(pEntity, this.getPosToAvoid(pEntity), this.speedModifier);
    }
}

