/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement.WaitingChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WaitingChatBubbleData
implements IChatBubbleData {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"waiting");
    private final int existTick;
    private final ResourceLocation bg;
    private final int priority;
    private final Component text;
    private final ResourceLocation icon;
    @OnlyIn(value=Dist.CLIENT)
    private IChatBubbleRenderer renderer;

    private WaitingChatBubbleData(int existTick, ResourceLocation bg, int priority, Component text, ResourceLocation icon) {
        this.existTick = existTick;
        this.bg = bg;
        this.priority = priority;
        this.text = text;
        this.icon = icon;
    }

    public static WaitingChatBubbleData create(int existTick, ResourceLocation bg, int priority, Component text, ResourceLocation icon) {
        return new WaitingChatBubbleData(existTick, bg, priority, text, icon);
    }

    public static WaitingChatBubbleData create(Component text, ResourceLocation icon) {
        return new WaitingChatBubbleData(300, TYPE_2, 0, text, icon);
    }

    @Override
    public int existTick() {
        return this.existTick;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IChatBubbleRenderer getRenderer(IChatBubbleRenderer.Position position) {
        if (this.renderer == null) {
            this.renderer = new WaitingChatBubbleRenderer(this.bg, this.text, this.icon);
        }
        return this.renderer;
    }

    public static class WaitingChatSerializer
    implements IChatBubbleData.ChatSerializer {
        @Override
        public IChatBubbleData readFromBuff(FriendlyByteBuf buf) {
            return new WaitingChatBubbleData(300, buf.readResourceLocation(), 0, (Component)buf.readJsonWithCodec(ComponentSerialization.CODEC), buf.readResourceLocation());
        }

        @Override
        public void writeToBuff(FriendlyByteBuf buf, IChatBubbleData data) {
            WaitingChatBubbleData textChat = (WaitingChatBubbleData)data;
            buf.writeResourceLocation(textChat.bg);
            buf.writeJsonWithCodec(ComponentSerialization.CODEC, (Object)textChat.text);
            buf.writeResourceLocation(textChat.icon);
        }
    }
}

