/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class EntityBox
extends Entity {
    public static final int FIRST_STAGE = 0;
    public static final int SECOND_STAGE = 1;
    public static final int THIRD_STAGE = 2;
    public static final int MAX_TEXTURE_SIZE = 8;
    private static final EntityDataAccessor<Integer> OPEN_STAGE = SynchedEntityData.defineId(EntityBox.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.defineId(EntityBox.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityType<EntityBox> TYPE = EntityType.Builder.of(EntityBox::new, (MobCategory)MobCategory.MISC).sized(2.0f, 2.0f).clientTrackingRange(10).build("box");
    private static final String STAGE_TAG = "OpenStage";
    private static final String TEXTURE_TAG = "TextureIndex";
    public long thirdStageTimeStamp = 0L;
    private int thirdStageTicks = 0;

    public EntityBox(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setRandomTexture();
    }

    public EntityBox(Level worldIn) {
        this(TYPE, worldIn);
    }

    public void baseTick() {
        if (!this.isNoGravity() && !this.onGround()) {
            this.move(MoverType.SELF, this.getDeltaMovement().add(0.0, -0.1, 0.0));
        }
        super.baseTick();
        int stage = this.getOpenStage();
        if (stage == 0) {
            this.getPassengers().stream().filter(e -> e instanceof TamableAnimal).forEach(e -> this.applyInvisibilityEffect((TamableAnimal)e));
        } else if (stage == 2) {
            ++this.thirdStageTicks;
            if (this.thirdStageTicks > 100) {
                this.addStageChange();
            }
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        this.addStageChange();
        if (this.getOpenStage() == 1) {
            this.playSound((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.getOpenStage() == 2) {
            this.thirdStageTimeStamp = System.currentTimeMillis();
            this.playSound((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        this.playSound((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 2.0f);
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OPEN_STAGE, (Object)0);
        builder.define(TEXTURE_INDEX, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains(STAGE_TAG)) {
            this.setOpenStage(compound.getInt(STAGE_TAG));
        }
        if (compound.contains(TEXTURE_TAG)) {
            this.setTextureIndex(compound.getInt(TEXTURE_TAG));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt(STAGE_TAG, this.getOpenStage());
        compound.putInt(TEXTURE_TAG, this.getTextureIndex());
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public int getOpenStage() {
        return (Integer)this.entityData.get(OPEN_STAGE);
    }

    private void setOpenStage(int stage) {
        this.entityData.set(OPEN_STAGE, (Object)stage);
    }

    public int getTextureIndex() {
        return (Integer)this.entityData.get(TEXTURE_INDEX);
    }

    private void setTextureIndex(int index) {
        this.entityData.set(TEXTURE_INDEX, (Object)Mth.clamp((int)index, (int)1, (int)7));
    }

    public void setRandomTexture() {
        this.setTextureIndex(this.random.nextInt(8));
    }

    private void addStageChange() {
        this.setOpenStage(this.getOpenStage() + 1);
        if (this.getOpenStage() > 2) {
            this.kill();
        }
    }

    public void kill() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY() + 0.25, this.getZ(), 20, 1.0, 1.0, 1.0, 0.2);
            ResourceKey table = this.getType().getDefaultLootTable();
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(table);
            LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.damageSources().genericKill());
            LootParams params = builder.create(LootContextParamSets.ENTITY);
            lootTable.getRandomItems(params, 0L, arg_0 -> ((EntityBox)this).spawnAtLocation(arg_0));
        }
        super.kill();
    }

    private void applyInvisibilityEffect(TamableAnimal tameable) {
        tameable.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 2, 1, false, false));
    }

    public Vec3 getPassengerRidingPosition(Entity pEntity) {
        return this.position().add(this.getPassengerAttachmentPoint(pEntity, this.getDimensions(Pose.STANDING), 1.0f)).subtract(0.0, 2.0, 0.0);
    }
}

