/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.config;

import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public class MaidConfigContainer
extends AbstractMaidContainer {
    public static final MenuType<MaidConfigContainer> TYPE = IMenuTypeExtension.create((windowId, inv, data) -> new MaidConfigContainer(windowId, inv, data.readInt()));
    private static final int PLAYER_INVENTORY_SIZE = 27;

    public MaidConfigContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
    }

    public static MenuProvider create(final int entityId) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Maid Config Container");
            }

            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                return new MaidConfigContainer(index, playerInventory, entityId);
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        };
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack1 = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack2 = slot.getItem();
            stack1 = stack2.copy();
            if (index < 27 ? !this.moveItemStackTo(stack2, 27, this.slots.size(), false) : !this.moveItemStackTo(stack2, 0, 27, true)) {
                return ItemStack.EMPTY;
            }
            if (stack2.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack1;
    }
}

